/* ***************************************************************** *
 * Copyright 1998 International Business Machines Corporation. All   *
 * Rights Reserved.                                                  *
 *                                                                   *
 * Please read this carefully.  Your use of this reference           *
 * implementation of certain of the IETF public-key infrastructure   *
 * specifications ("Software") indicates your acceptance of the      *
 * following.  If you do not agree to the following, do not install  *
 * or use any of the Software.                                       *
 *                                                                   *
 * Permission to use, reproduce, distribute and create derivative    *
 * works from the Software ("Software Derivative Works"), and to     *
 * distribute such Software Derivative Works is hereby granted to    *
 * you by International Business Machines Corporation ("IBM").  This *
 * permission includes a license under the patents of IBM that are   *
 * necessarily infringed by your use of the Software as provided by  *
 * IBM.                                                              *
 *                                                                   *
 * IBM licenses the Software to you on an "AS IS" basis, without     *
 * warranty of any kind.  IBM HEREBY EXPRESSLY DISCLAIMS ALL         *
 * WARRANTIES OR CONDITIONS, EITHER EXPRESS OR IMPLIED, INCLUDING,   *
 * BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OR CONDITIONS OF       *
 * MERCHANTABILITY, NON INFRINGEMENT AND FITNESS FOR A PARTICULAR    *
 * PURPOSE.  You are solely responsible for determining the          *
 * appropriateness of using this Software and assume all risks       *
 * associated with the use of this Software, including but not       *
 * limited to the risks of program errors, damage to or loss of      *
 * data, programs or equipment, and unavailability or interruption   *
 * of operations.                                                    *
 *                                                                   *
 * IBM WILL NOT BE LIABLE FOR ANY DIRECT DAMAGES OR FOR ANY SPECIAL, *
 * INCIDENTAL, OR  INDIRECT DAMAGES OR FOR ANY ECONOMIC              *
 * CONSEQUENTIAL DAMAGES (INCLUDING LOST PROFITS OR SAVINGS), EVEN   *
 * IF IBM HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH DAMAGES.  IBM  *
 * will not be liable for the loss of, or damage to, your records or *
 * data, or any damages claimed by you based on a third party claim. *
 *                                                                   *
 * IBM wishes to obtain your feedback to assist in improving the     *
 * Software.  You grant IBM a world-wide, royalty-free right to use, *
 * copy, distribute, sublicense and prepare derivative works based   *
 * upon any feedback, including materials, error corrections,        *
 * Software Derivatives, enhancements, suggestions and the like that *
 * you provide to IBM relating to the Software (this does not        *
 * include products for which you charge a royalty and distribute to *
 * IBM under other terms and conditions).                            *
 *                                                                   *
 * You agree to distribute the Software and any Software Derivatives *
 * under a license agreement that: 1) is sufficient to notify all    *
 * licensees of the Software and Software Derivatives that IBM       *
 * assumes no liability for any claim that may arise regarding the   *
 * Software or Software Derivatives, and 2) that disclaims all       *
 * warranties, both express and implied, from IBM regarding the      *
 * Software and Software Derivatives.  (If you include this          *
 * Agreement with any distribution of the Software or Software       *
 * Derivatives you will have met this requirement.)  You agree that  *
 * you will not delete any copyright notices in the Software.        *
 *                                                                   *
 * This Agreement is the exclusive statement of your rights in the   *
 * Software as provided by IBM.   Except for the rights granted to   *
 * you in the second paragraph above, You are not granted any other  *
 * patent rights, including but not limited to the right to make     *
 * combinations of the Software with products that infringe IBM      *
 * patents. You agree to comply with all applicable laws and         *
 * regulations, including all export and import laws and regulation. *
 * This Agreement is governed by the laws of the State of New York.  *
 * This Agreement supersedes all other communications,               *
 * understandings or agreements we may have had prior to this        *
 * Agreement.                                                        *
 * ***************************************************************** */

#include "exception.hpp"
#include "misc.hpp"
#include "cssmerr.h"
#include <iostream.h>

/**********************************************************
 *
 *	CssmData class
 *
 **********************************************************/
CssmData::CssmData() {
	length = 0;
	data = NULL;
	sensitive = CSSM_FALSE;
}

CssmData::CssmData(uint32 _length) {
	length = _length;
	if (_length == 0)
		data = NULL;
	else
		data = new uint8[_length];

	sensitive = CSSM_FALSE;
}

CssmData::CssmData(uint32 _length, uint8* _data) {
	length = 0;
	sensitive = CSSM_FALSE;
	setData(_length, _data);
}

CssmData::CssmData(CSSM_DATA_PTR cssmData) {
	length = 0;
	sensitive = CSSM_FALSE;
	if (cssmData == NULL)
		throw InternalException(0);

	setData(cssmData->Length, cssmData->Data);
}

CssmData::~CssmData() {
	if (sensitive == NULL)
		destroy();

	if (data != NULL)
		delete data;
}

void CssmData::setLength(uint32 _length) {
	if (length != 0) {
		if (sensitive == CSSM_TRUE)
			destroy();

		delete data;
	}

	length = _length;
	if (_length == 0) {
		data = NULL;
		return;
	}

	data = new uint8[_length];
}

void CssmData::setData(CSSM_DATA_PTR _data) {
	if (_data == NULL) {
		setLength(0);
		return;
	}

	setData(_data->Length, _data->Data);
}

/*****************************************************
 * Copies _length bytes from _data
 *****************************************************/
void CssmData::setData(uint32 _length, uint8* _data) {
	if ((_data == NULL) && (_length != 0))
		throw InternalException(0);

//I think this is OK! -> This allows me to copy 0 bytes from a non-NULL
//location
//	if ((_data != NULL) && (_length == 0))
//		throw InternalException(0);
	
	if (length != 0) {
		if (sensitive == CSSM_TRUE)
			destroy();

		delete data;
	}

	length = _length;
	if (length == 0) {
		data = NULL;
		return;
	}

	data = new uint8[length];
	memcpy(data, _data, length);
	return;
}

void CssmData::setDestroy(CSSM_BOOL _destroy) {
	sensitive = _destroy;
}

uint32 CssmData::getLength() {
	return(this->length);
}

uint8* CssmData::getData() {
	return(this->data);
}

CSSM_DATA* CssmData::exportCssmData() {
	CSSM_DATA_PTR	cssmData = new CSSM_DATA;

	cssmData->Length = length;
	if (length == 0) {
		cssmData->Data = NULL;
	}
	else {
		cssmData->Data = new uint8[length];
		memcpy(cssmData->Data, data, length);
	}

	return(cssmData);
}

void CssmData::destroy() {
	if (length == 0)
		return;

	memset(data, '\0', length);
}

CssmData& CssmData::clone() {
	CssmData* tmpCssmData = new CssmData(length, data);
	return (*tmpCssmData);
}

/****************************************
 * New handler
 ****************************************/
int myNewHandler(size_t size) {
	cout << "Failed to allocate " << size << " bytes!" << endl;
	throw MemoryException(CSSM_CSP_MEMORY_ERROR);
	return(CSSM_CSP_MEMORY_ERROR);
}
