/* ***************************************************************** *
 * Copyright 1998 International Business Machines Corporation. All   *
 * Rights Reserved.                                                  *
 *                                                                   *
 * Please read this carefully.  Your use of this reference           *
 * implementation of certain of the IETF public-key infrastructure   *
 * specifications ("Software") indicates your acceptance of the      *
 * following.  If you do not agree to the following, do not install  *
 * or use any of the Software.                                       *
 *                                                                   *
 * Permission to use, reproduce, distribute and create derivative    *
 * works from the Software ("Software Derivative Works"), and to     *
 * distribute such Software Derivative Works is hereby granted to    *
 * you by International Business Machines Corporation ("IBM").  This *
 * permission includes a license under the patents of IBM that are   *
 * necessarily infringed by your use of the Software as provided by  *
 * IBM.                                                              *
 *                                                                   *
 * IBM licenses the Software to you on an "AS IS" basis, without     *
 * warranty of any kind.  IBM HEREBY EXPRESSLY DISCLAIMS ALL         *
 * WARRANTIES OR CONDITIONS, EITHER EXPRESS OR IMPLIED, INCLUDING,   *
 * BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OR CONDITIONS OF       *
 * MERCHANTABILITY, NON INFRINGEMENT AND FITNESS FOR A PARTICULAR    *
 * PURPOSE.  You are solely responsible for determining the          *
 * appropriateness of using this Software and assume all risks       *
 * associated with the use of this Software, including but not       *
 * limited to the risks of program errors, damage to or loss of      *
 * data, programs or equipment, and unavailability or interruption   *
 * of operations.                                                    *
 *                                                                   *
 * IBM WILL NOT BE LIABLE FOR ANY DIRECT DAMAGES OR FOR ANY SPECIAL, *
 * INCIDENTAL, OR  INDIRECT DAMAGES OR FOR ANY ECONOMIC              *
 * CONSEQUENTIAL DAMAGES (INCLUDING LOST PROFITS OR SAVINGS), EVEN   *
 * IF IBM HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH DAMAGES.  IBM  *
 * will not be liable for the loss of, or damage to, your records or *
 * data, or any damages claimed by you based on a third party claim. *
 *                                                                   *
 * IBM wishes to obtain your feedback to assist in improving the     *
 * Software.  You grant IBM a world-wide, royalty-free right to use, *
 * copy, distribute, sublicense and prepare derivative works based   *
 * upon any feedback, including materials, error corrections,        *
 * Software Derivatives, enhancements, suggestions and the like that *
 * you provide to IBM relating to the Software (this does not        *
 * include products for which you charge a royalty and distribute to *
 * IBM under other terms and conditions).                            *
 *                                                                   *
 * You agree to distribute the Software and any Software Derivatives *
 * under a license agreement that: 1) is sufficient to notify all    *
 * licensees of the Software and Software Derivatives that IBM       *
 * assumes no liability for any claim that may arise regarding the   *
 * Software or Software Derivatives, and 2) that disclaims all       *
 * warranties, both express and implied, from IBM regarding the      *
 * Software and Software Derivatives.  (If you include this          *
 * Agreement with any distribution of the Software or Software       *
 * Derivatives you will have met this requirement.)  You agree that  *
 * you will not delete any copyright notices in the Software.        *
 *                                                                   *
 * This Agreement is the exclusive statement of your rights in the   *
 * Software as provided by IBM.   Except for the rights granted to   *
 * you in the second paragraph above, You are not granted any other  *
 * patent rights, including but not limited to the right to make     *
 * combinations of the Software with products that infringe IBM      *
 * patents. You agree to comply with all applicable laws and         *
 * regulations, including all export and import laws and regulation. *
 * This Agreement is governed by the laws of the State of New York.  *
 * This Agreement supersedes all other communications,               *
 * understandings or agreements we may have had prior to this        *
 * Agreement.                                                        *
 * ***************************************************************** */

#ifndef _KEY_HPP
#define _KEY_HPP

#include "cssmtype.h"
#include "ibmcylinkcsp.hpp"
#include "toolkit.h"
#include "misc.hpp"

class DllExport AlgorithmParams {
public:
	AlgorithmParams(uint32 _algId);
	virtual ~AlgorithmParams();

	uint32	getAlgId();

	virtual uint32		getLength() = 0;
	virtual CssmData&	exportCssmData() = 0;
	virtual uint32		getSizeInBits() = 0;

private:
	uint32	algId;
};

class DllExport KeyMaterial {
	friend class Key;
	friend class KeyGenEngine;

public:
	KeyMaterial(CSSM_GUID *_cspGuid, uint32 _algId, uint32 _blobType, uint32 _format, uint32 _keyClass);
	KeyMaterial(uint32 _algId, uint32 _blobType, uint32 _format, uint32 _keyClass);
	virtual ~KeyMaterial();

	CSSM_GUID*	getCspGuid();
	uint32		getAlgId();
	uint32		getBlobType();
	uint32		getFormat();
	uint32		getWrapAlgId();
	uint32		getWrapMode();
	uint32		getKeyClass();

	//part of keyGen
	virtual void		importAlgParams(AlgorithmParams *params);
	virtual void		copy(KeyMaterial *material);	

	virtual void*		importCssmKey(CSSM_KEY_PTR key) = 0;
	virtual CssmData&	exportPublicCssmData();
	virtual CssmData&	exportCssmData() = 0;
	virtual uint32		getSizeInBits() = 0;
	virtual uint32		getEffectiveSizeInBits() = 0;
	virtual void		destroy() = 0;
	virtual	KeyMaterial* clone() = 0;

protected:
	//I am not sure I want the GUID to be part of the KeyMat!!!
	CSSM_GUID	cspGuid;
	uint32		algId;
	uint32		blobType;
	uint32		format;
	uint32		wrapAlgId;
	uint32		wrapMode;
	uint32		keyClass; //public, private, secret ...
};

class DllExport Key {
	friend class KeyGenEngine;
	friend class KeyGen;

public:
	Key(CSSM_GUID *cspId, uint32 algId, uint32 keyClass, uint32 usage, uint32 attr, CSSM_DATE *start, CSSM_DATE *end);
	Key(const CSSM_KEY_PTR key);
	Key(const Key& key);
	~Key();

private:
	void KeySetup(CSSM_GUID *cspId, uint32 algId, uint32 keyClass, uint32 usage, uint32 attr, CSSM_DATE *start, CSSM_DATE *end);
	KeyMaterial* instantiateKeyMat();

public:
	CSSM_GUID*	getCspId();
	uint32		getAlgId();
	void		setKeyClass(uint32 keyClass);
	uint32		getKeyClass();
	void		setUsage(uint32 usage);
	uint32		getUsage();
	void		setAttr(uint32 attr);
	uint32		getAttr();
	void		setStartDate(CSSM_DATE *startDate);
	CSSM_DATE*	getStartDate();
	void		setEndDate(CSSM_DATE *endDate);
	CSSM_DATE*	getEndDate();
	uint32		getBlobType();
	uint32		getFormat();
	uint32		getWrapAlgId();
	uint32		getWrapMode();
	uint32		getSizeInBits();
	uint32		getEffectiveSizeInBits();
	void		importKeyMat(KeyMaterial *material);
	//it will be part of keyGen
	//void		importAlgParams(AlgorithmParams *params);
	CSSM_KEY*	exportCssmPublicKey();
	CSSM_KEY*	exportCssmKey();
	KeyMaterial* exportKeyMat();
	Key*		clone();
	void		destroy();

private:
	CSSM_GUID	cspGuid;
	uint32		algId;
	uint32		keyClass; //public, private, session, secret, other
	uint32		usage;
	uint32		attr;	//permanent, pivate, ...
	CSSM_DATE	startDate;
	CSSM_DATE	endDate;
	KeyMaterial *keyMat;
};

#endif //_KEY_HPP
