#include <asnbase.h>
#include <stdio.h>
#include <stdlib.h>

int main(int argc, char * argv[]) {
  asn_integer i1;
  asn_integer i2;
  long val;
  uint32 status;
  buffer_t encoding;
  unsigned i;
  char line[256];

  while (true) {
    fprintf(stdout,"Int: "); fflush(stdout);
    fgets(line, sizeof(line), stdin);
    line[sizeof(line)-1] = 0;
    if (line[strlen(line)-1] == '\n') line[strlen(line)-1] = '\0';
    if (strlen(line) == 0) break;
    val = atol(line);
    status = i1.set_value(val);
    if (status) {
      fprintf(stderr, "Error %lu setting integer value\n", status);
      return EXIT_FAILURE;
    };
    encoding.clear();
    status = i1.write(encoding);
    if (status) {
      fprintf(stderr, "Error %lu encoding integer value\n", status);
      return EXIT_FAILURE;
    };
    fprintf(stdout, "Encoding: ");
    for (i=0; i<encoding.data_len; i++) {
      fprintf(stdout, "%2.2X ", encoding[i]);
    };
    fprintf(stdout, "\n");
    status = i2.read(encoding);
    if (status) {
      fprintf(stderr, "Error %lu parsing encoding\n", status);
      return EXIT_FAILURE;
    };
    status = i2.get_value(val);
    if (status) {
      fprintf(stderr, "Error %lu extracting value\n", status);
      return EXIT_FAILURE;
    };
    fprintf(stdout, "Value: %d\n", val);
  };
}