/* ***************************************************************** *
 * Copyright 1998 International Business Machines Corporation. All   *
 * Rights Reserved.                                                  *
 *                                                                   *
 * Please read this carefully.  Your use of this reference           *
 * implementation of certain of the IETF public-key infrastructure   *
 * specifications ("Software") indicates your acceptance of the      *
 * following.  If you do not agree to the following, do not install  *
 * or use any of the Software.                                       *
 *                                                                   *
 * Permission to use, reproduce, distribute and create derivative    *
 * works from the Software ("Software Derivative Works"), and to     *
 * distribute such Software Derivative Works is hereby granted to    *
 * you by International Business Machines Corporation ("IBM").  This *
 * permission includes a license under the patents of IBM that are   *
 * necessarily infringed by your use of the Software as provided by  *
 * IBM.                                                              *
 *                                                                   *
 * IBM licenses the Software to you on an "AS IS" basis, without     *
 * warranty of any kind.  IBM HEREBY EXPRESSLY DISCLAIMS ALL         *
 * WARRANTIES OR CONDITIONS, EITHER EXPRESS OR IMPLIED, INCLUDING,   *
 * BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OR CONDITIONS OF       *
 * MERCHANTABILITY, NON INFRINGEMENT AND FITNESS FOR A PARTICULAR    *
 * PURPOSE.  You are solely responsible for determining the          *
 * appropriateness of using this Software and assume all risks       *
 * associated with the use of this Software, including but not       *
 * limited to the risks of program errors, damage to or loss of      *
 * data, programs or equipment, and unavailability or interruption   *
 * of operations.                                                    *
 *                                                                   *
 * IBM WILL NOT BE LIABLE FOR ANY DIRECT DAMAGES OR FOR ANY SPECIAL, *
 * INCIDENTAL, OR  INDIRECT DAMAGES OR FOR ANY ECONOMIC              *
 * CONSEQUENTIAL DAMAGES (INCLUDING LOST PROFITS OR SAVINGS), EVEN   *
 * IF IBM HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH DAMAGES.  IBM  *
 * will not be liable for the loss of, or damage to, your records or *
 * data, or any damages claimed by you based on a third party claim. *
 *                                                                   *
 * IBM wishes to obtain your feedback to assist in improving the     *
 * Software.  You grant IBM a world-wide, royalty-free right to use, *
 * copy, distribute, sublicense and prepare derivative works based   *
 * upon any feedback, including materials, error corrections,        *
 * Software Derivatives, enhancements, suggestions and the like that *
 * you provide to IBM relating to the Software (this does not        *
 * include products for which you charge a royalty and distribute to *
 * IBM under other terms and conditions).                            *
 *                                                                   *
 * You agree to distribute the Software and any Software Derivatives *
 * under a license agreement that: 1) is sufficient to notify all    *
 * licensees of the Software and Software Derivatives that IBM       *
 * assumes no liability for any claim that may arise regarding the   *
 * Software or Software Derivatives, and 2) that disclaims all       *
 * warranties, both express and implied, from IBM regarding the      *
 * Software and Software Derivatives.  (If you include this          *
 * Agreement with any distribution of the Software or Software       *
 * Derivatives you will have met this requirement.)  You agree that  *
 * you will not delete any copyright notices in the Software.        *
 *                                                                   *
 * This Agreement is the exclusive statement of your rights in the   *
 * Software as provided by IBM.   Except for the rights granted to   *
 * you in the second paragraph above, You are not granted any other  *
 * patent rights, including but not limited to the right to make     *
 * combinations of the Software with products that infringe IBM      *
 * patents. You agree to comply with all applicable laws and         *
 * regulations, including all export and import laws and regulation. *
 * This Agreement is governed by the laws of the State of New York.  *
 * This Agreement supersedes all other communications,               *
 * understandings or agreements we may have had prior to this        *
 * Agreement.                                                        *
 * ***************************************************************** */

#include <stdio.h>
#include <Jonah.h>
#include <base64.h>
#include <tid.h>
#include <x509.h>
#include <pkix_messages.h>
#include <PreReg.h>
#include <ObjectStore.h>
#include <ObjectDefs.h>
#include <JonahOst.h>
#include <JonahIni.h>
#include <jnhTimer.h>
#include <ApiNotify.h>
#include <messaging.h>
#include <apimsg.h>
#include <POLICY/CertPol.h>

uint32
JNH_reject_registration(uint32 reqId, utf8String message)
{
  uint32        status;
  uint32        objClass;
  ObjStoreData  *objsPtr;
  long          id;
  CertResponse  *respPtr;
  CertRepMessage *cr;
  
 do {
   if ((status = JnhLockObject(reqId))) {
     break;
   }
   if ((status = JnhGetObjectModify(reqId, &objClass, &objsPtr))) {
      break;
    }
    switch(objsPtr->msg.value.selected()) {
    case OBJ_MSG_IREQ:
      objsPtr->msg.value.select(OBJ_MSG_IREP);
      cr = &objsPtr->msg.value.irep.value;
      break;
    case OBJ_MSG_CERTREQ:
      objsPtr->msg.value.select(OBJ_MSG_CERTREP);
      cr = &objsPtr->msg.value.certrep.value;
      break;
    default:
      status = API_IMPROPER_MESSAGE_TYPE;
      break;
    }
    if (status) break;
    if ((respPtr = cr->response.add_child()) == NULL) {
      throw "Out of memory in reject certificate";
    }
    if ((objsPtr->msg.value.ireq.value[0]->certReq.certReqId.get_value(id))) {
      break;
    }
    if ((status = respPtr->certReqId.set_value(id))) {
      break;
    }
    if ((status = respPtr->status.status.set_value(REJECTION))) {
      break;
    }
    if (( status = respPtr->status.failInfo.
          set_value(message, strlen((char *) message)+1))) {
      break;
    }
    objClass = (ObjClStActive | ObjClTypeCert);
    if (IniAmIRA()) {
      objClass = objClass | ObjStRACertReqRejecting;
    } else if (IniAmICA()) {
      objClass = objClass | ObjStCACertReqRejected;
    } else {
      status = API_WRONG_SERVER;
      break;
    }
    JnhSetObjectFlags(reqId, objClass);
    ApiNotify(reqId, objClass);
  } while(0);
  if (status) {
    JnhDiscardObject(reqId);
  } else {
    status = JnhSynchObject(reqId);
  }
  return status;
}

uint32
JNH_validate_registration(uint32 reqId)
{
  uint32        status;
  uint32        objClass;
  ObjStoreData  *objsPtr = NULL;
  CertTemplate  *ct = NULL;
  bool		ibool;
  char		inialgname[BUFSIZ];

  do {
    if ((status = JnhLockObject(reqId))) {
      break;
    } 
    if ((status = JnhGetObjectModify(reqId, &objClass, &objsPtr))) {
      break;
    }
    switch(objsPtr->msg.value.selected()) {
    case OBJ_MSG_IREQ:
      ct = &objsPtr->msg.value.ireq.value[0]->certReq.certTemplate;
      break;
    case OBJ_MSG_CERTREQ:
      ct = &objsPtr->msg.value.certreq.value[0]->certReq.certTemplate;
      break;
    default:
      status =  API_IMPROPER_MESSAGE_TYPE;
      break;
    }
    if (status) break;
    if (IniAmIRA()) {
      if (!ct->version.value.is_present()) {
        if ((status = ct->version.value.set_value(2))) {
          break;
        }
      }
      if (!ct->signingAlg.value.is_present()) {
        char *algname = (char *) malloc(BUFSIZ);
        if (algname == NULL) {
          throw "Out of memory error in RA_authorize_registration";
        }
	sprintf(inialgname, "%s%d", CP_SIGALG, 1);
        if ((ibool = IniReadString(CP_SECTION, inialgname, algname, 
				   BUFSIZ)) == FALSE) {
	  status = API_NO_ALG;
	  break;
	}
        if ((status = ct->signingAlg.value.algorithm.set_value(algname))) {
          free(algname);
          break;
        }
        free(algname);
      }
    }
    if ((status = CP_NewCertVerify(*ct))) {
      break;
    }
  } while(0);
  if (status) {
    JnhDiscardObject(reqId);
  } else {
    JnhSynchObject(reqId);
  }
  return status;
}
