/**
   SSLSocket.c

   Copyright (C) 1999, RTFM, Inc.
   All Rights Reserved.

   ekr@rtfm.com  Thu Jun 10 06:31:00 1999
 */


static char *RCSSTRING="$Id: SSLSocket.c,v 1.1.1.1 1999/06/17 18:49:02 ekr Exp $";

#include "COM_claymore_sslg_openssl_SSLSocket.h"
#include <stdio.h>
#include <sys/types.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <openssl/ssl.h>
#include <native_common.h>


     
JNIEXPORT jint JNICALL Java_COM_claymore_sslg_openssl_SSLSocket_getCipherSuite
  (JNIEnv *env, jobject thisObj)
  {
    c_SSLSocket *sock;
    SSL_CIPHER *ciph;
    
    if(!(sock=get_context(env,thisObj)))
      return 0;
    ciph=SSL_get_current_cipher(sock->ssl);

    return(ciph->id & 0xffff);
  }

JNIEXPORT jint JNICALL Java_COM_claymore_sslg_openssl_SSLSocket_getVersion
  (JNIEnv *env, jobject thisObj)
  {
    c_SSLSocket *sock;
    
    if(!(sock=get_context(env,thisObj)))
      return 0;

    return(SSL_version(sock->ssl));
  }

/* TODO: We're going to have to hack SSLeay to add this, so we're
   just going to throw an error now*/
JNIEXPORT void JNICALL Java_COM_claymore_sslg_openssl_SSLSocket_sendClose
  (JNIEnv *env, jobject thisObj)
  {
    throw_exception(env,thisObj,
      "java/lang/InternalError","sendClose not implemented");
  }
JNIEXPORT void JNICALL Java_COM_claymore_sslg_openssl_SSLSocket_waitForClose
  (JNIEnv *env, jobject thisObj, jboolean enforceClose)
  {
    throw_exception(env,thisObj,
      "java/lang/InternalError","waitForClose not implemented");
  }

JNIEXPORT void JNICALL Java_COM_claymore_sslg_openssl_SSLSocket_nativeClose
  (JNIEnv *env, jobject thisObj)
  {
    c_SSLSocket *sock;
    
    if(!(sock=get_context(env,thisObj)))
      return;
    
    SSL_shutdown(sock->ssl);
    SSL_free(sock->ssl);
    close(sock->sock);
    free(sock);
  }
