/**
   SSLClient.java

   Copyright (C) 1999, Claymore Systems, Inc.
   All Rights Reserved.

   ekr@rtfm.com  Fri Jun 18 07:57:59 1999

   This package is a SSLv3/TLS implementation written by Eric Rescorla
   <ekr@rtfm.com> and licensed by Claymore Systems, Inc.

   Redistribution and use in source and binary forms, with or without
   modification, are permitted provided that the following conditions
   are met:
   1. Redistributions of source code must retain the above copyright
      notice, this list of conditions and the following disclaimer.
   2. Redistributions in binary form must reproduce the above copyright
      notice, this list of conditions and the following disclaimer in the
      documentation and/or other materials provided with the distribution.
   3. All advertising materials mentioning features or use of this software
      must display the following acknowledgement:
      This product includes software developed by Claymore Systems, Inc.
   4. Neither the name of Claymore Systems, Inc. nor the name of Eric
      Rescorla may be used to endorse or promote products derived from this
      software without specific prior written permission.

   THIS SOFTWARE IS PROVIDED BY THE REGENTS AND CONTRIBUTORS ``AS IS'' AND
   ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
   IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
   ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE LIABLE
   FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
   DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
   OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
   HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
   LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
   OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
   SUCH DAMAGE.

   $Id: SSLClient.java,v 1.4 1999/06/22 18:19:45 ekr Exp $

*/

package COM.claymoresystems.ptls.demo;
import COM.claymoresystems.cert.*;
import COM.claymoresystems.ptls.*;
import COM.claymoresystems.sslg.*;
import gnu.getopt.Getopt;
import gnu.getopt.LongOpt;
import java.security.SecureRandom;
import java.io.*;
import java.util.Vector;

/**
   This client emulates a simple web client.
*/
class SSLClient {
     // The default host/port to connect to
     private static String host="localhost";
     private static int port=4433;
     private static String keyfile="client.pem";
     private static String rootfile="root.pem";
     private static String password="password";
     private static LongOpt Longopts[]=new LongOpt[8];
     private static int iterate=1;
     private static boolean acceptunverified=false;
     
     static {
       int i=0;
       
       Longopts[i++]=new LongOpt("host",LongOpt.REQUIRED_ARGUMENT, null, 'h');
       Longopts[i++]=new LongOpt("port",LongOpt.REQUIRED_ARGUMENT, null, 'p');
       Longopts[i++]=new LongOpt("keyfile",LongOpt.REQUIRED_ARGUMENT, null, 'k');
       Longopts[i++]=new LongOpt("rootfile",LongOpt.REQUIRED_ARGUMENT, null, 'r');
       Longopts[i++]=new LongOpt("iterate",LongOpt.REQUIRED_ARGUMENT, null, 'i');
       Longopts[i++]=new LongOpt("password",LongOpt.REQUIRED_ARGUMENT, null, 'P');
       Longopts[i++]=new LongOpt("debug",LongOpt.REQUIRED_ARGUMENT, null, 'd');
       Longopts[i++]=new LongOpt("acceptunverified",LongOpt.NO_ARGUMENT, null, 'u');              
     }
     
     private static void testConn(SSLContext c,String host,int port)
       throws IOException, java.net.UnknownHostException {
       try {
	 SSLSocket s;
	 s=new SSLSocket(c,host,port);

	 Vector cc=s.getCertificateChain();

	 if(cc!=null){
	   System.out.println("Cert chain");

	 
	   for(int i=0;i<cc.size();i++){
	     X509Cert cert=(X509Cert)cc.elementAt(i);

	     System.out.println("Issuer "+cert.getIssuerName().getNameString());
	     System.out.println("Subject "+cert.getSubjectName().getNameString());
	     System.out.println("Serial "+cert.getSerial());
	     System.out.println("Validity "+cert.getValidityNotBefore() +"-"+
	       cert.getValidityNotAfter());

	   }
	 }	   
	 byte buf[]=new byte[4096];

	 InputStreamReader ir=new InputStreamReader(s.getInputStream());
	 BufferedReader br=new BufferedReader(ir);
	 
	 OutputStreamWriter or=new OutputStreamWriter(s.getOutputStream());
	 BufferedWriter bw=new BufferedWriter(or);

	 bw.write("GET / HTTP/1.0\r\n");
	 bw.write("User-Agent: PureTLS Client demo program\r\n");
	 bw.write("\r\n\r\n");
	 bw.flush();

	 for(;;){
	   try {
	     String str=br.readLine();
	     if(str==null)
	       break;
	     System.out.println(str);
	   } catch (SSLReHandshakeException e){
	     System.out.println("Renegotiate requested. Renegotiating");
	     s.renegotiate();
	   }

	 }
	 
	 s.close();
       }       
       catch (SSLAlertException e){
	 throw new Error(e.toString());
       }
     }

     private static void usage() {
       System.out.println("SSLClient usage ");
       System.out.println("SSLClient [args]");
       System.out.println("  --host, -h: the host to connect to (default localhost)");
       System.out.println("  --port, -h: the port to connect to (default 4433)");
       System.out.println("  --keyfile, -k: the keyfile to use (default dsakeys.pem)");
       System.out.println("  --rootfile, -r: the rootfile to use (default root.pem)");
       System.out.println("  --password, -P: the password to use (default password)");
       System.out.println("  --iterate, -i: repeat the test fetch some number of times (default 1");
       System.out.println("    demonstrates session caching");
       System.out.println("  --debug, -d: set the debugging flags");
       System.out.println("  --acceptunverified, -u: accept unverifieable certificates");
     }
     public static void main(String[] args){
       int c;
       
       Getopt g=new Getopt("SSLClient", args, "h:p:k:r:Ri:d:u",Longopts);

       while((c=g.getopt())!=-1)
	 switch(c){
	   case 'h':
	     host=new String(g.getOptarg());
	     break;
	   case 'p':
	     port=Integer.parseInt(g.getOptarg());
	     break;
	   case 'k':
	     keyfile=new String(g.getOptarg());
	     break;
	   case 'r':
	     rootfile=new String(g.getOptarg());
	     break;
	   case 'P':
	     password=new String(g.getOptarg());
	     break;
	   case 'i':
	     iterate=Integer.parseInt(g.getOptarg());
	     break;
	   case 'u':
	     acceptunverified=true;
	     break;
	   case 'd':
	     SSLDebug.setDebug(Integer.parseInt(g.getOptarg()));
	     break;
	   default:
	     usage();
	     return;
	 }

       SSLContext ctx=new SSLContext();
       SSLPolicyInt policy=new SSLPolicyInt();

       policy.acceptUnverifiableCertificates(acceptunverified);
       ctx.setPolicy(policy);
       
       try {
	 ctx.loadRootCertificates(rootfile);

	 ctx.loadEAYKeyFile(keyfile,password);
	 
	 while(iterate-->0){
	   testConn(ctx,host,port);
	 }
       } catch (Exception e){
	 e.printStackTrace();
       }
     }
}

