/* set_key.c v 1.3 eay 16/7/90
 * 1.3 added register declarations.
 * 1.2 unrolled make_key_sched a bit more
 * 1.1 added norm_expand_bits
 * 1.0 First working version
 */
#include "des_local.h"
#include "podd.h"
#include "bits.h"
#include "ksp.h"

static void norm_expand_bits();
static int check_parity();
static int make_key_sched();

int des_check_key=0;

void des_set_odd_parity(key)
des_cblock key;
	{
	int i;

	for (i=0; i<DES_KEY_SZ; i++)
		key[i]=odd_parity[key[i]];
	}

static int check_parity(key)
des_cblock key;
	{
	int i;

	for (i=0; i<DES_KEY_SZ; i++)
		{
		if (key[i] != odd_parity[key[i]])
			return(0);
		}
	return(1);
	}

/* Weak and semi week keys as take from
 * %A D.W. Davies
 * %A W.L. Price
 * %T Security for Computer Networks
 * %I John Wiley & Sons
 * %D 1984
 * Many thanks to smb@ulysses.att.com (Steven Bellovin) for the reference
 * (and actual cblock values).
 */
#define NUM_WEAK_KEY	16
static des_cblock weak_keys[NUM_WEAK_KEY]={
	/* weak keys */
	0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,
	0xFE,0xFE,0xFE,0xFE,0xFE,0xFE,0xFE,0xFE,
	0x1F,0x1F,0x1F,0x1F,0x1F,0x1F,0x1F,0x1F,
	0xE0,0xE0,0xE0,0xE0,0xE0,0xE0,0xE0,0xE0,
	/* semi-weak keys */
	0x01,0xFE,0x01,0xFE,0x01,0xFE,0x01,0xFE,
	0xFE,0x01,0xFE,0x01,0xFE,0x01,0xFE,0x01,
	0x1F,0xE0,0x1F,0xE0,0x0E,0xF1,0x0E,0xF1,
	0xE0,0x1F,0xE0,0x1F,0xF1,0x0E,0xF1,0x0E,
	0x01,0xE0,0x01,0xE0,0x01,0xF1,0x01,0xF1,
	0xE0,0x01,0xE0,0x01,0xF1,0x01,0xF1,0x01,
	0x1F,0xFE,0x1F,0xFE,0x0E,0xFE,0x0E,0xFE,
	0xFE,0x1F,0xFE,0x1F,0xFE,0x0E,0xFE,0x0E,
	0x01,0x1F,0x01,0x1F,0x01,0x0E,0x01,0x0E,
	0x1F,0x01,0x1F,0x01,0x0E,0x01,0x0E,0x01,
	0xE0,0xFE,0xE0,0xFE,0xF1,0xFE,0xF1,0xFE,
	0xFE,0xE0,0xFE,0xE0,0xFE,0xF1,0xFE,0xF1};

int des_is_weak_key(key)
des_cblock key;
	{
	ulong *lp;
	register ulong l,r;
	int i;

	c2l(key,l);
	c2l(key,r);
	/* the weak_keys bytes should be alligned */
	lp=(ulong *)weak_keys;
	for (i=0; i<NUM_WEAK_KEY; i++)
		{
		if ((l == lp[0]) && (r == lp[1]))
			return(1);
		lp+=2;
		}
	return(0);
	}

/* return 0 if key parity is odd (correct),
 * return -1 if key parity error,
 * return -2 if illegal weak key.
 */
int des_set_key(key,schedule)
des_cblock *key;
des_key_schedule schedule;
	{
	char k[64];

	if (des_check_key)
		{
		if (!check_parity(key))
			return(-1);

		if (des_is_weak_key(key))
			return(-2);
		}

	norm_expand_bits(key,k,64);
	make_key_sched(k,schedule);
	return(0);
	}

static void norm_expand_bits(from,to,num)
register unsigned char *from;
unsigned char *to;
int num;
	{
        int i,n;
        register unsigned char f;

        n=num>>3;
        for (i=0; i<n; i++)
                {
                f= *(from++);
                *(to++) = (f&0x01)?1:0;
                *(to++) = (f&0x02)?1:0;
                *(to++) = (f&0x04)?1:0;
                *(to++) = (f&0x08)?1:0;
                *(to++) = (f&0x10)?1:0;
                *(to++) = (f&0x20)?1:0;
                *(to++) = (f&0x40)?1:0;
                *(to++) = (f&0x80)?1:0;
                }
	}

static int make_key_sched(key,schedule)
register char *key;
des_key_schedule schedule;
	{
	register unsigned int *kp;
	register unsigned long t;
	unsigned char *k;
	int i;

	kp=(unsigned int *)kp_table;
	k=(unsigned char *)schedule;

	for (i=0; i<ITERATIONS; i++)
		{
		t=0;
		if (key[kp[0]]) t|=(ulong)(1L<<0);
		if (key[kp[1]]) t|=(ulong)(1L<<1);
		if (key[kp[2]]) t|=(ulong)(1L<<2);
		if (key[kp[3]]) t|=(ulong)(1L<<3);
		if (key[kp[4]]) t|=(ulong)(1L<<4);
		if (key[kp[5]]) t|=(ulong)(1L<<5);

		if (key[kp[6]]) t|=(ulong)(1L<<8);
		if (key[kp[7]]) t|=(ulong)(1L<<9);
		if (key[kp[8]]) t|=(ulong)(1L<<10);
		if (key[kp[9]]) t|=(ulong)(1L<<11);
		if (key[kp[10]]) t|=(ulong)(1L<<12);
		if (key[kp[11]]) t|=(ulong)(1L<<13);

		if (key[kp[12]]) t|=(ulong)(1L<<16);
		if (key[kp[13]]) t|=(ulong)(1L<<17);
		if (key[kp[14]]) t|=(ulong)(1L<<18);
		if (key[kp[15]]) t|=(ulong)(1L<<19);
		if (key[kp[16]]) t|=(ulong)(1L<<20);
		if (key[kp[17]]) t|=(ulong)(1L<<21);

		if (key[kp[18]]) t|=(ulong)(1L<<24);
		if (key[kp[19]]) t|=(ulong)(1L<<25);
		if (key[kp[20]]) t|=(ulong)(1L<<26);
		if (key[kp[21]]) t|=(ulong)(1L<<27);
		if (key[kp[22]]) t|=(ulong)(1L<<28);
		if (key[kp[23]]) t|=(ulong)(1L<<29);
		l2c(t,k);
		t=0;

		if (key[kp[24]]) t|=(ulong)(1L<<0);
		if (key[kp[25]]) t|=(ulong)(1L<<1);
		if (key[kp[26]]) t|=(ulong)(1L<<2);
		if (key[kp[27]]) t|=(ulong)(1L<<3);
		if (key[kp[28]]) t|=(ulong)(1L<<4);
		if (key[kp[29]]) t|=(ulong)(1L<<5);

		if (key[kp[30]]) t|=(ulong)(1L<<8);
		if (key[kp[31]]) t|=(ulong)(1L<<9);
		if (key[kp[32]]) t|=(ulong)(1L<<10);
		if (key[kp[33]]) t|=(ulong)(1L<<11);
		if (key[kp[34]]) t|=(ulong)(1L<<12);
		if (key[kp[35]]) t|=(ulong)(1L<<13);

		if (key[kp[36]]) t|=(ulong)(1L<<16);
		if (key[kp[37]]) t|=(ulong)(1L<<17);
		if (key[kp[38]]) t|=(ulong)(1L<<18);
		if (key[kp[39]]) t|=(ulong)(1L<<19);
		if (key[kp[40]]) t|=(ulong)(1L<<20);
		if (key[kp[41]]) t|=(ulong)(1L<<21);

		if (key[kp[42]]) t|=(ulong)(1L<<24);
		if (key[kp[43]]) t|=(ulong)(1L<<25);
		if (key[kp[44]]) t|=(ulong)(1L<<26);
		if (key[kp[45]]) t|=(ulong)(1L<<27);
		if (key[kp[46]]) t|=(ulong)(1L<<28);
		if (key[kp[47]]) t|=(ulong)(1L<<29);
		kp+=48;
		l2c(t,k);
		}
	return(0);
	}

int key_sched(key,schedule)
des_cblock *key;
des_key_schedule schedule;
	{
	return(des_set_key(key,schedule));
	}

