;;;  $Id: irchat-hooks.el,v 1.3 1993/07/13 18:33:12 tmo Exp $
;;;
;;;  Example hooks to customize irchat. These are copy-pasted from 2.2beta
;;;  and modified a bit. The might or might not work. The general idea is 
;;;  that if hook returns nil, the appropriate handler is called after the 
;;;  hook. Any other value returned causes further processing of message 
;;;  cancelled.

(provide 'irchat-hooks)

(defun string-memberp (thing list)
  "Dummy case insensitive function to check if string THING is a member of
LIST"
  (cond ((null list) nil)
        ((string-equal (downcase thing) (downcase (car list))) t)
        (t (string-memberp thing (cdr list)))))

;;;
;;;
;;;
(defvar irchat-watched-nicks '("God" "Pope" "Paavi" "JuhaF|hr"))


;(defun irchat-join-hook (prefix rest)
;   "Join hook, that gives mode +o for users at hosts mathing *.fi. This was
;used on #42 for long time ago."
;  (if (string-match "kuolepois" prefix)
;      (setq irchat-join-hook nil)
;    (if (and (string-match "\\(.fi\\)" irchat-userathost)
;             (= (match-end 0) (match-end 1)))
;        (irchat-send (format "mode %s +o %s" rest prefix)))))

(defun irchat-join-hook (nick channel)
  (cond
   ((string= "#report" channel)
    t)
   ;; greet persons at current channel
   ((and (string-memberp nick irchat-watched-nicks)
         (string= irchat-current-channel channel))
    (progn
      (beep)
      (irchat-Command-send-message (format "%s: et ole kuitenkaan aito" nick))
      (message "%s has joined channel %s" nick channel)
      nil))
   (t nil)))


(defun irchat-part-hook (prefix rest)
  (if (string= "#report" rest)
      t nil))


(setq irchat-join-hook (function irchat-join-hook))
(setq irchat-part-hook (function irchat-part-hook))


;;;
;;;
;;;
(defun irchat-privmsg-hook (prefix rest)
  (if (and irchat-broadcast-partner (not irchat-chat-partner))
      (progn
	(if (eq prefix nil)
	    (setq prefix "")
	  (setq prefix (concat "<" prefix "> ")))
	(if (and (string= prefix "")
		 (string-match (format "^%s.*" (format irchat-format-string1)) rest))
	    nil
	  (progn 
	    (string-match "[^ ]* :\\(.*\\)" rest)
	    (irchat-send "PRIVMSG %s :%s%s" irchat-broadcast-partner prefix
			 (matching-substring rest 1))))
	nil)
    nil))


(defun irchat-msg-hook (prefix rest)
  (if (and irchat-broadcast-partner (not irchat-chat-partner))
      (progn
	(if (eq prefix nil)
	    (setq prefix "")
	  (setq prefix (concat "<" prefix "> ")))
	(if (and (string= prefix "")
		 (string-match (format "^%s.*" (format irchat-format-string1)) rest))
	    nil
	  (progn 
	    (string-match "[^ ]* :\\(.*\\)" rest)
	    (irchat-send "PRIVMSG %s :%s%s" irchat-broadcast-partner prefix
			 (matching-substring rest 1))))
	nil)
    nil))
	    

(setq irchat-privmsg-hook (function irchat-privmsg-hook))
(setq irchat-msg-hook (function irchat-msg-hook))
;;;
;;;  eof
;;;