#include <stdio.h>
#include "conf.h"
#ifdef FAKESYSLOG
#include "fsyslog.h"
#else
#include <syslog.h>
#endif
#include <sys/time.h>
#include <sys/types.h>
#include <errno.h>
#include "readline.h"
#include "nntplink.h"

extern Boolean Abort_signaled;
extern long Close_timeout;
extern Boolean Debug;
extern long Exit_timeout;
extern long Idle_time;
extern Boolean Reset_signaled;

extern void abort_nntplink();
extern void close_connection();
extern void fail();
extern void log();
extern void reset_logfile();

#ifdef HAVE_SELECT
struct timeval timeout = {0, 0};
#endif

void
  check_sleep(sleep_time)
long sleep_time;
{
    static char *fname = "check_sleep: ";

    Idle_time += sleep_time;

    if ((Idle_time > Close_timeout) && (Host.connected) && 
	(Close_timeout != NEVER)) {

	dlog(LOG_DEBUG, fname, "%sreached close timeout\n");
	close_connection(WAIT);
    }

    if (Abort_signaled ||
	((Exit_timeout != NEVER) && (Idle_time > Exit_timeout))) {

	if (Debug && !Abort_signaled)
	  dlog(LOG_DEBUG, fname, "%sreached exit timeout\n");

	abort_nntplink();
    }

    if (Reset_signaled)
      update_batchfile();

#ifdef HAVE_SELECT
    timeout.tv_sec = sleep_time;
    if ((select(0,0,0,0,&timeout) == FAIL) && (errno != EINTR))
      fail(fname,
	   "%s%s: select() failed (please recompile without HAVE_SELECT): %s",
	   Host.name, errmsg(errno));
#else
    (void) sleep((unsigned)sleep_time);
#endif

    dlog(LOG_DEBUG, "", "%s.");

    return;
}


