#include "conf.h"
#include <errno.h>
#include <fcntl.h>
#include <signal.h>
#include <stdio.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <sys/time.h>
#ifdef FAKESYSLOG
#include "fsyslog.h"
#else
#include <syslog.h>
#endif
#include "readline.h"
#include "nntplink.h"

extern char *E_fstat;
extern char *E_fseek;

extern Boolean Autobackground;
extern Boolean Debug;
extern long Idle_time;
extern int Input_from;
extern Boolean One_shot;
extern int Prog_pid;
extern char *Prog_name;
extern long Success_time;

extern void check_batchfile();
extern void check_sleep();
extern char *errmsg();
extern void fail();
extern void log();
extern void read_link_datafile();
extern void sighandler();
extern void write_link_datafile();

void
  setup_proc()
{
    static char *fname = "setup_proc: ";
    int fd;
    struct stat statb;
    int pid;

    Time.begin_real = Success_time = time(NULL);

    if (signal(SIGINT, SIG_IGN) != SIG_IGN)
      signal(SIGINT, sighandler);
    if (signal(SIGHUP, SIG_IGN) != SIG_IGN)
      signal(SIGHUP, sighandler);
    if (signal(SIGTERM, SIG_IGN) != SIG_IGN)
      signal(SIGTERM, sighandler);
    if (signal(SIGPIPE, SIG_IGN) != SIG_IGN)
      signal(SIGPIPE, sighandler);
#ifdef SIGURG
    if (signal(SIGURG, SIG_IGN) != SIG_IGN)
      signal(SIGURG, sighandler);
#endif
    
    if (Autobackground) {
	if ((pid = fork()) < 0)
	  fail(fname, "%s%s: fork failed\n", Prog_name);

	if (pid != 0)			/* Parent exits */
	  exit(0);

#ifdef HAVE_SYSV_SETPGRP
	(void) setpgrp();
#ifdef TIOCNOTTY
	fd = open("/dev/tty", 2);	/* disconnect from the tty */
	if (fd >= 0) {
	    (void) ioctl(fd, TIOCNOTTY, NULL);
	    (void) close(fd);
	}
#endif /* TIOCNOTTY */
#else /* !HAVE_SYSV_SETPGRP */
	(void) setpgrp(0, 0);
#endif /* HAVE_SYSV_SETPGRP */
    }

    Prog_pid = getpid();

#ifdef LOG_NFACILITIES
    (void) openlog(Prog_name, LOG_PID, SYSLOG);
#else
    (void) openlog(Prog_name, LOG_PID);
#endif

    if (!One_shot) {
	read_link_datafile();
	write_link_datafile();
    }

    if (Input_from & FLG_LOGFILE) {

	dlog(LOG_DEBUG, fname, "%swaiting for logfile: ");

	if (One_shot) {
	    if ((fd = open(Logfile.name, O_RDONLY)) == FAIL)
	      fail(fname, "%s%s: %s not found on a One-shot\n", Host.name,
		   Logfile.name);
	} else
	  while ((fd = open(Logfile.name, O_RDONLY)) == FAIL)
	    check_sleep(Logfile.nap_time);

	dlog(LOG_DEBUG, "", "%sgot it\n");

	if (fstat(fd, &statb) == FAIL)
	  fail(fname, E_fstat, Host.name, Logfile.name, errmsg(errno));

	Logfile.fbp = fb_fdopen(fd);
	if ((statb.st_ino == Logfile.inode) && (Logfile.offset != 0) &&
	    (fb_seek(Logfile.fbp, Logfile.offset, 0) == FAIL))
	  log(LOG_WARNING, fname, E_fseek, Host.name, Logfile.name,
	      errmsg(errno));
	else
	  Logfile.inode = statb.st_ino;

	write_link_datafile();

    } else if (Input_from & FLG_STDIN) {

	Stdin.fbp = fb_fdopen(fileno(stdin));
    }

    check_batchfile();

    return;
}
