#ifndef READLINE_H__
#define READLINE_H__

/* 
 * fb_rbufsz has to be at least the size of a line.  The buffer is twice
 * fb_rbufsz, for the double buffering effect, so we can always read in a
 * page aligned chunk starting at fb_rbuf in case the OS is being
 * intelligent.  Partial lines at the end of fb_rbuf are moved before
 * fb_rbuf so newly read data will be contiguous with the partial lines.
 */
/* !! should use off_t instead of unsigned long for fb_offset */

typedef struct {
	int fb_rbufsz;		/* rbuf is rbufsz * 2 bytes long */
	char *fb_rbuf;		/* middle of double buffer */
	char *fb_curp;		/* start of unread data */
	char *fb_endp;		/* end of unread data */
	unsigned long fb_offset;/* offset into the file corresp. to fb_curp */
	int fb_fd;		/* file descriptor */
#define FB__ERR	0x1
#define FB__EOF	0x2
	unsigned int fb_flags;	/* error or eof */
} FileBuf;

/* Internal routine, not to be used by user, only for fb_getc(). */
extern int fb__refill(/* FileBuf *fbp */);

extern FileBuf *fb_fdopen(/* int fd */);
extern char *fb_readline(/* FileBuf *fbp */);
extern int fb_getc(/* FileBuf *fbp */);
extern unsigned long fb_tell(/* FileBuf *fbp */);
extern int fb_seek(/* FileBuf *fbp, long offset, int whence */);
extern void fb_close(/* FileBuf *fbp */);
extern int fb_fileno(/* FileBuf *fbp */);
extern int fb_err(/* FileBuf *fbp */);
extern int fb_eof(/* FileBuf *fbp */);

#define fb_tell(fbp)	((fbp)->fb_offset)
#define fb_getc(fbp) (((fbp)->fb_curp != (fbp)->fb_endp) ? \
		      (fbp)->fb_offset++, (int) *(fbp)->fb_curp++ : \
		      fb__refill((fbp)))
#define fb_fileno(fbp)	((fbp)->fb_fd)
#define fb_err(fbp)	((fbp)->fb_flags & FB__ERR)
#define fb_eof(fbp)	((fbp)->fb_flags & FB__EOF)

#endif /* READLINE_H__ */ /* Do not add anything after this line */
