#include "conf.h"
#ifdef HAVE_STRINGS
#include <strings.h>
#else
#include <string.h>
#endif
#include <errno.h>
#include <stdio.h>
#ifdef FAKESYSLOG
#include "fsyslog.h"
#else
#include <syslog.h>
#endif
#ifdef USE_VARARGS
#include <varargs.h>
#endif
#include <sys/types.h>
#include <values.h>
#include <varargs.h>
#include "readline.h"
#include "nntplink.h"


extern Boolean Debug;
extern FILE *Debugfp;
extern long Entry_sleep;
extern long Idle_time;
extern int Input_from;
extern Boolean One_shot;
extern int Prog_pid;

extern void check_sleep();
extern void close_connection();
extern char *emalloc();
extern void log();
extern void log_stats();
extern void update_batchfile();

extern void exit();

#ifdef USE_VARARGS
void
  log(va_alist)
va_dcl
{
    va_list ap;
    char *fname, *format;
    char *buf;
    int priority;

    va_start(ap);
    priority = va_arg(ap, int);
    fname = va_arg(ap, char *);
    format = va_arg(ap, char *);
    format += 2;

    if (Debug) {
	if (fputs(fname, Debugfp) == EOF) {
	    fprintf(stderr, "log: fputs failed - %s\n", errmsg(errno));
	    exit(FAIL);
	}
	if (vfprintf(Debugfp, format, ap) == EOF) {
	    fprintf(stderr, "log: vfprintf failed - %s\n", errmsg(errno));
	    exit(FAIL);
	}
	fflush(Debugfp);
    } else {
	buf = emalloc(1024);
	vsprintf(buf, format, ap);
	syslog(priority, buf);
	free(buf);
    }

    va_end(ap);
    return;
}

void
  fail(va_alist)
va_dcl
{
    va_list ap;
    char *fname, *format;
    char *buf;

    va_start(ap);
    fname = va_arg(ap, char *);
    format = va_arg(ap, char *);
    format += 2;

    if (Debug) {
	if (fputs(fname, Debugfp) == EOF) {
	    fprintf(stderr, "fail: fputs failed - %s\n", errmsg(errno));
	    exit(FAIL);
	}
	if (vfprintf(Debugfp, format, ap) == EOF) {
	    fprintf(stderr, "fail: vfprintf failed - %s\n", errmsg(errno));
	    exit(FAIL);
	}
	fflush(Debugfp);
    } else {
	vsprintf(buf, format, ap);
	syslog(LOG_ERR, buf);
    }
    va_end(ap);
    exit(FAIL);
}

#else /* !USE_VARARGS */

/*VARARGS*/
void
  log(priority, fname, format, x1, x2, x3, x4, x5, x6, x7, x8)
int priority;
char *fname;
char *format, *x1, *x2, *x3, *x4, *x5, *x6, *x7, *x8;
{
    if (Debug) {

	if (fprintf(Debugfp, format, fname, x1, x2, x3, x4, x5, x6, x7, x8) == EOF) {
	    fprintf(stderr, "log: fprintf failed - %s\n", errmsg(errno));
	    exit(FAIL);
	}
	fflush(Debugfp);

    } else
      syslog(priority, format, "", x1, x2, x3, x4, x5, x6, x7, x8);

    return;
}


/*VARARGS*/
void
  fail(fname, format, x1, x2, x3, x4, x5, x6, x7, x8)
char *fname;
char *format, *x1, *x2, *x3, *x4, *x5, *x6, *x7, *x8;
{

    log(LOG_ERR, fname, format, x1, x2, x3, x4, x5, x6, x7, x8);

    exit(FAIL);
}
#endif /* !USE_VARARGS */


char *
  my_readline(fbp)
FileBuf *fbp;
{
    static char *fname = "my_readline: ";
    register char *line;

    if (Debug)
      if (Input_from & FLG_LOGFILE)
	log(LOG_DEBUG, fname, "%swaiting for Logfile entry: ");
      else if (Input_from & FLG_BATCHFILE)
	log(LOG_DEBUG, fname, "%swaiting for Batchfile entry: ");
      else
	log(LOG_DEBUG, fname, "%swaiting for <stdin> entry: ");

    while (((line = fb_readline(fbp)) == NULL) && fb_eof(fbp))
      check_sleep(Entry_sleep);

    if (fb_error(fbp))
      return NULL;

    dlog(LOG_DEBUG, "", "%sgot it\n");

    return line;
}


void
  abort_nntplink()
{
    static char *fname = "abort_nntplink: ";

    dlog(LOG_DEBUG, fname, "%sexiting\n");

    Prog_pid = -999;

    if (!(Input_from & FLG_BATCHFILE) && !One_shot)
      update_batchfile();

    log_stats();

    if (Host.connected)
      close_connection(DONT_WAIT);

    exit(0);
}

char *
itoa(num)
     int num;
{
    static char *numbers = "0123456789";
    static char *neg = "-";
    register char *bp, *negative = neg + 1;
    char *buf = emalloc(MAXDIGS);

    if (num == 0)
      return "0";
    else if (num > MAXINT)
      return NULL;
    
    *(bp = buf + MAXDIGS) = '\0';

    if ((long)num < 0) {
	negative--;
	num = -num;
    }

    do {
	*--bp = *(numbers + (num % 10));
	num /= 10;
    } while (num);

    if (*negative)
      *--bp = *negative;

    return bp;
}
