#include <stdio.h>
#include "conf.h"
#ifdef FAKESYSLOG
#include "fsyslog.h"
#else
#include <syslog.h>
#endif
#include <sys/types.h>
#ifdef HAVE_GETRUSAGE
#include <sys/time.h>
#include <sys/resource.h>
#else
#include <sys/param.h>
#include <sys/times.h>
#endif
#include "readline.h"
#include "nntplink.h"

extern Boolean Debug;
extern int Input_from;
extern Boolean One_shot;

extern char *E_rename;

extern void fail();
extern void log();
extern void write_link_datafile();

static int logged_stats = 0;

int Clear_batchfile = CLEAR_BATCHFILE;
Boolean Report_stats = TRUE;


void
  log_stats()
{
    static char *fname = "log_stats: ";
    double temp;

#ifdef HAVE_GETRUSAGE
    struct rusage self, kids;

    (void) getrusage(RUSAGE_SELF, &self);
    (void) getrusage(RUSAGE_CHILDREN, &kids);

    Time.end_user = (double)(self.ru_utime.tv_sec + kids.ru_utime.tv_sec +
			     self.ru_utime.tv_usec/1000000. +
			     kids.ru_utime.tv_usec/1000000.);

    Time.end_sys = (double)(self.ru_stime.tv_sec + kids.ru_stime.tv_sec +
			    self.ru_stime.tv_usec/1000000. +
			    kids.ru_stime.tv_usec/1000000.);
#else /* !HAVE_GETRUSAGE */
    struct tms cpu;

    (void) times(&cpu);

    Time.end_user = (double)(cpu.tms_utime + cpu.tms_cutime) / HZ;
    Time.end_sys  = (double)(cpu.tms_stime + cpu.tms_cstime) / HZ;
#endif	/* HAVE_GETRUSAGE */

    Time.end_real = time(NULL);

    if (Report_stats) {

	log(LOG_INFO, fname,
	    "%s%s stats %lu offered %lu accepted %lu rejected %lu failed\n",
	    Host.name, Stats.offered, Stats.accepted, Stats.rejected,
	    Stats.failed);

	log(LOG_INFO, fname,
	    "%s%s xmit user %.1f system %.1f elapsed %ld\n",
	    Host.name, (Time.end_user - Time.begin_user),
	    (Time.end_sys - Time.begin_sys),
	    (Time.end_real - Time.begin_real));

	if ((temp = ((Time.end_real - Time.begin_real) / 60.)) == 0.)
	  log(LOG_INFO, fname,
	      "%s%s xfer offer/min <Inf> accept/min <Inf>\n", Host.name);
	else
	  log(LOG_INFO, fname,
	      "%s%s xfer offer/min %2.2f accept/min %2.2f\n", Host.name,
	      Stats.offered/temp, Stats.accepted/temp);

	Time.begin_real = Time.end_real;
	Time.begin_user = Time.end_user;
	Time.begin_sys = Time.end_sys;
	Stats.offered = Stats.accepted = Stats.rejected = Stats.failed = 0L;
    }

    if (!One_shot) {
	write_link_datafile();

	if ((Input_from & FLG_BATCHFILE) &&
	    (++logged_stats >= Clear_batchfile)) {

	    logged_stats = 0;

	    if (!Batchfile.nntp_in_use && (Batchfile.fbp != NULL)) {
		Batchfile.nntp_in_use = TRUE;

		dlog(LOG_DEBUG, fname,
		     "%srenaming batchfile to batchfile.nntp\n");

		if (rename(Batchfile.name, Batchfile.nname) == FAIL)
		  fail(fname, E_rename, Host.name, Batchfile.name,
		       Batchfile.nname, errmsg(errno));
	    }
	}
    }
}
