#include <errno.h>
#include <fcntl.h>
#include <stdio.h>
#include "conf.h"
#ifdef FAKESYSLOG
#include "fsyslog.h"
#else
#include <syslog.h>
#endif
#include <sys/types.h>
#include <sys/stat.h>
#include "readline.h"
#include "nntplink.h"

extern char *E_fdopen;
extern char *E_open;

extern Boolean Abort_signaled;
extern Boolean Debug;
extern long Entry_sleep;
extern long Idle_time;
extern int Input_from;
extern Boolean One_shot;
extern Boolean Save_fails;

extern char *E_fopen;
extern char *E_unlink;


#ifdef LOOKUP_ARTICLE
extern void close_history();
extern char *get_history_entry();
#endif

extern void check_sleep();
extern void close_article();
extern void fail();
extern void log();
extern char *my_readline();
extern Boolean parse_entry();


Boolean
  get_next_art()
{
    static char *fname = "get_next_art: ";
    FILE *tmpfp;
    struct stat batch_stat;
    char *entry;
    int already = 0;

    if (Article.count >= MAX_ART_FAILS) {

	if (Save_fails) {

	    if (Article.err != NULL)
	      log(LOG_NOTICE, fname, "%s%s: article %s failed(saved): %s\n",
		  Host.name, Article.filename, Article.err);
	    else
	      log(LOG_NOTICE, fname, "%s%s: article %s failed(saved)\n",
		  Host.name, Article.filename);

	    if ((tmpfp = fopen(Host.failfile, "a")) == NULL)
	      log(LOG_WARNING, fname, E_fopen, Host.name, Host.failfile, "a",
		  errmsg(errno));
	    else {
#ifdef CNEWS
		fprintf(tmpfp, "%s %s %d\n", Article.filename, Article.mesgid,
			Article.count);
#else
		fprintf(tmpfp, "%s\t%s\t%d\n", Article.filename,
			Article.mesgid,	Article.count);
#endif
		FCLOSE(tmpfp);
	    }
	} else
	  if (Article.err != NULL)
	    log(LOG_NOTICE, fname, "%s%s: article %s failed(junked): %s\n",
		Host.name, Article.filename, Article.err);
	  else
	    log(LOG_NOTICE, fname, "%s%s: article %s failed(junked)\n",
		Host.name, Article.filename);

	close_article();
    }

    if (Article.mesgid != NULL)
      return TRUE;

    if (Batchfile.use) {

	if (Debug)
	  if (Batchfile.nntp_in_use)
	    log(LOG_DEBUG, fname,
		"%sretrieving article from batchfile.nntp\n");
	  else
	    log(LOG_DEBUG, fname, "%sretrieving article from batchfile\n");

	for (;;) {
	    if (!Batchfile.nntp_in_use) {
		if (!One_shot) {
		    if ((entry = my_readline(Batchfile.fbp)) == NULL) {
			log(LOG_WARNING, fname,
			    "%s%s: error reading %s: %s\n", Host.name,
			    Batchfile.name, errmsg(errno));
			return FALSE;
		    }
		} else
		  if ((entry = fb_readline(Batchfile.fbp)) == NULL) {
		      if (Debug)
			if (fb_eof(Batchfile.fbp))
			  log(LOG_DEBUG, fname,
			      "%sbatchfile at EOF - removing and exiting\n");
			else
			  log(LOG_DEBUG, fname,
			      "%serror reading batchfile: %s\n",
			      errmsg(errno));
		      close(fb_fileno(Batchfile.fbp));
		      fb_close(Batchfile.fbp);
		      Batchfile.inode = Batchfile.offset = 0;
		      if (unlink(Batchfile.name) == FAIL)
			log(LOG_WARNING, fname, E_unlink, Host.name,
			    Batchfile.name, errmsg(errno));
		      Abort_signaled = TRUE;
		      return FALSE;
		  }
	    } else {

		while(((entry = fb_readline(Batchfile.fbp)) == NULL) &&
		      fb_eof(Batchfile.fbp)) {
		    if (!(Input_from & FLG_BATCHFILE) ||
			(stat(Batchfile.name, &batch_stat) != FAIL)) {

			dlog(LOG_DEBUG, fname,
			     "%sbatchfile.nntp at EOF - removing\n");

			close(fb_fileno(Batchfile.fbp));
			Batchfile.inode = Batchfile.offset = 0;
			fb_close(Batchfile.fbp);
			Batchfile.fbp = NULL;
			Batchfile.nntp_in_use = FALSE;

			if (unlink(Batchfile.nname) == FAIL)
			  log(LOG_WARNING, fname, E_unlink, Host.name,
			      Batchfile.nname, errmsg(errno));

			return FALSE;
		    }

		    if (Debug && !already++)
		      log(LOG_DEBUG, fname, "%sbatchfile.nntp at EOF: ");

		    check_sleep(Entry_sleep);
		}
		if (fb_error(Batchfile.fbp))
		  fail(fname,
		       "%s%s: error reading %s: %s\n", Host.name,
		       Batchfile.nname, errmsg(errno));
	    }
	    if (parse_entry(entry))
	      return TRUE;
	}
    }

    if (Input_from & FLG_LOGFILE) {

	dlog(LOG_DEBUG, fname,
	     "%sretrieving next article from logfile\n");

	if (!One_shot) {
	    while (((entry = my_readline(Logfile.fbp)) != NULL) &&
		   (!parse_entry(entry)))
	      ;
	    if (entry == NULL) {
		log(LOG_WARNING, fname,
		    "%s%s: error reading %s: %s\n", Host.name,
		    Logfile.name, errmsg(errno));
		return FALSE;
	    }
	} else {
	    while (((entry = fb_readline(Logfile.fbp)) != NULL) &&
		   (!parse_entry(entry)))
		   ;

	    if (entry == NULL) {
		if (Debug)
		  if (fb_eof(Logfile.fbp))
		    log(LOG_DEBUG, fname, "%sLogfile at EOF - exiting\n");
		  else
		    log(LOG_DEBUG, fname,
			"%Serror reading logfile: %s\n",
			errmsg(errno));
		Abort_signaled = TRUE;
		return FALSE;
	    }
	}

    } else if (Input_from & FLG_STDIN) {

	if (!One_shot) {
	    while (((entry = my_readline(Stdin.fbp)) != NULL) &&
		   (!parse_entry(entry)))
	      ;
	    if (entry == NULL) {
		log(LOG_WARNING, fname,
		    "%s%s: error reading stdin: %s\n", Host.name,
		    errmsg(errno));
		return FALSE;
	    }
	} else {
	    while (((entry = fb_readline(Stdin.fbp)) != NULL) &&
		   (!parse_entry(entry)))
	      ;

	    if (entry == NULL) {
		if (Debug)
		  if (fb_eof(Stdin.fbp))
		    log(LOG_DEBUG, fname, "%sStdin at EOF - exiting\n");
		  else
		    log(LOG_DEBUG, fname,
			"%serror reading stdin: %s\n",
			errmsg(errno));
		Abort_signaled = TRUE;
		return FALSE;
	    }
	}
    } else
      fail(fname, "%s%s: Input_from has invalid value - exiting\n",
	   Host.name);

    return TRUE;
}

void
  close_article()
{
    Article.filename = NULL;
    Article.mesgid = NULL;

    if (Article.fbp != NULL) {
	close(fb_fileno(Article.fbp));
	fb_close(Article.fbp);
	Article.fbp = NULL;
    }

    if (Article.err != NULL)
	FREE(Article.err);

    Article.count = 0;

    return;
}


Boolean
  open_article()
{
    static char *fname = "open_article: ";
    int fd;

#ifdef LOOKUP_ARTICLE
    if (Article.filename == NULL) {

	Article.filename = get_history_entry(Article.mesgid, WANT_FILENAME);

	/*
	 * If we failed then we want to close the history file and retry
	 * since it's possible that the history file got aged.
	 */
	if (Article.filename == NULL) {
	    close_history();
	    Article.filename = get_history_entry(Article.mesgid,
						 WANT_FILENAME);
	    if (Article.filename == NULL) {
		log(LOG_INFO, fname, "%s%s: Filename not found for %s\n",
		    Host.name, Article.mesgid);
		return FALSE;
	    }
	}

	dlog(LOG_DEBUG, fname, "%shistory returns %s\n", Article.filename);
    }
#endif /* LOOKUP_ARTICLE */

    if ((fd = open(Article.filename, O_RDONLY)) == FAIL) {
	if (errno != ENOENT)
	  log(LOG_WARNING, fname, E_open, Host.name, Article.filename, "r",
	      errmsg(errno));
	else
	  dlog(LOG_DEBUG, fname, "%sArticle(%s) not found\n",
	       Article.filename);

	return FALSE;
    }

    Article.fbp = fb_fdopen(fd);

    return TRUE;
}
