#
# access-filter.pl -- Disallow access to certain paths
#
# access-filter.pl,v 1.4 1994/06/23 05:42:41 sanders Exp
#
# by Tony Sanders <sanders@earth.com>, Oct 1993
#
# Read a configuration file and disallow certain paths
# Requires configuration.

sub access {
    local($fromfd, $peeraddr, $action, $path, $version) = @_;
    local($_, $pat) = $path;
    foreach $pat (@access_filter'lines) {
        if ((chop $pat) eq 'p') {
            # pass
            /$pat/ && last;
	} else {
	    # fail
	    /$pat/ && &main'error('forbidden', "$action $path invalid");
	}
    }
}

package access_filter;

&access_filter'config($main'plexus{'access-filter-config'});

sub config {
    &main'debug("config $_[0]");
    local($config) = shift || die "access-filter: no config file\n";
    local($pat);
    @lines = ();
    &main'open("access_filter'CONFIG", $config) || die "$config: $!";
    while (<CONFIG>) {
        if (/^\s*pass\s*(.*)/) { $pat = &main'globpat($1); push(@lines, $pat . 'p'); next; }
        if (/^\s*fail\s*(.*)/) { $pat = &main'globpat($1); push(@lines, $pat . 'f'); next; }
    }
    close(CONFIG);
}

1;
