# This implements x,y checking for positions on a picture.
# see the file doc/xy_decoding.html for more information.
#
# Ben Johnson   johnsonb@stolaf.edu   9/4/93
# http://www.stolaf.edu/people/student/johnsonb/johnsonb.html

sub get_url_from_xy {
    local(%reference);
    local($path,$query) = @_;
    open(IN,"<${path}_ismap.xpm") || &error('internal_error',"Couldn't open ${path}_ismap.xpm for reading\n");
    local($xpos,$ypos) = split(',',$query);
    local($i,$j);
    local(@rest);
    # if there's a better way to do this, I'd like to know.
    local(@rest) = split (/\//,$path);
    local($filename) = pop( @rest );
    $path=join('/',@rest );
    (@rest ) = split (/\./,$filename);
    local($file_extension) = pop(@rest);

    #### get the size
    $/ = ',';			# separate on commas.
    # x size, y size, number of unique colors, and characters per color
    local($xsize,$ysize,$num_colors,$cpc) = split(/\s+/,&get_xpm_line($_=<IN>));
    # this will parse the colors
    local($char,$rest,$trib,$val);
    for($i = 0 ; $i < $num_colors ; $i++ ) {
	($char,$rest) = unpack("a1 a*",&get_xpm_line($_ = <IN>));
	# the unpack does not get rid of the whitespace separater.  Here we do.
	$rest =~ s:^\s*::g;
	@rest = split(/\s+/,$rest);
	while(@rest) {
	    ($trib,$val,@rest) = @rest;
	    if ($trib eq 's') {
		$reference{$char} = $val ;
	    }
	}
    }
    # got the colors and their URL, now find the right character.
    # now get the actual character
    # hopefull, no one is stupid enough to put comments inside the 
    # actual picture: (can't separate on commas, since ',' is a valid character
    $/ = "\n";
    for($h = 0 ; $h < $ypos ; $h++ ) { $_ = <IN>; }
    $_ = &get_xpm_line ( $_ = <IN> );
    $type = substr($_,$xpos * $cpc , $cpc ) ;
    return 
	($reference{$type} =~ s:^/:: )
	    ? "$reference{$type}.$file_extension"
	    : "$path/$reference{$type}.$file_extension";
}

sub get_xpm_line {
    local($_) = @_;
    if (/^\n",/) { #\"
	$_ .= <IN>;
    }
    $_ =~ s:\n::g;
    $_ =~  s:/\*.*\*/::g ;
    $_ =~ s:^[^"]*"([^"]*)".*$:$1:;
    return $_;
}

1;
