Date:         Thu, 16 Jun 1994 15:37:26 +1000
From:         John Farrell <farrell@cs.jcu.edu.au>
To:           sanders@earth.com
Subject:      image map in plexus

Tony, I am trying to an image map in plexus. Now my image contains lots of
shapes which are convex polygons but not rectangles, so I decided to add a new
method for decoding, i.e. whether a point was in a given polygon or not.
Included below is a program inpoly.c which returns correct values.
So I set up all the necessary bits for my map, which meant I just had to code
the polygon decoding in decode.pl. This is probably where my problem is,
because I don't know much perl. Anyway, I based it on the decoding for rect.

In map configuration file:

map_handle poly x1 y1 x2 y2 x3 y3 ... xn yn URL

>From decode.pl:

            } elsif ($_[1] =~ /rect/i) {
                # decode by rectangle
                local($x, $y, $w, $h, $URL) = @_[2..6];
                unless (defined($query)) {
                    splice(@_,0,7,());                  # delete 0..7
                    push(@menu, join(" ", ($URL, @_))); # rest is menu text
                    next;
                }
                if (($x < $X) && (($x+$w) > $X) &&
                        ($y < $Y) && (($y+$h) > $Y)) {
                    return &retrieve($URL);
                }
            } elsif ($_[1] =~/poly/i) {
                # decode by polygon
                local ($URL,$answer) = (@_[$#_],undef);
                splice(@_,$#_);
                splice(@_,0,2,("server/inpoly",$X,$Y));
                $answer = join($",@_);
                system($answer);
                if ($? == 0) { return &retrieve($URL); }
            }

  As you can see, after the join, the inpoly command is in answer. This is
exactly of the form required. I do the system, which evaluates to -1, and have
a look at $? to see whether to return the URL or not. Now the problem is that
$? returns either 1 or 4096, not 0, 256 or 512 as you would expect.
  I tried printing yes or no from inpoly, and on the occasions when this was
returned to the web browser it gave a correct answer. I tried to capture the
output of the inpoly command in a perl variable and compare it, but I couldn't
get that to work either.
  PLEASE TELL ME WHAT I AM DOING WRONG! Your reward for this is the inpoly
program which you can bundle up and distribute with plexus if you like, or
rewrite in perl if you're worried about time taken to execute subprocesses.
This would give plexus the ability to define polygons in images, which other
http servers can't do.
  Anyway, thanks for your help. I don't think I'm far wrong, and it sure would
be nice to get this working.

John Farrell
Department of Computer Science
James Cook University
Townsville 4811

P.S. The map url is http://coral.cs.jcu.edu.au:8001/aerial/aerial.html.
The http server might be down.

P.P.S. I also hacked in support for POST requests, but it was so easy that I'm
wondering why you didn't do it already.
----------
#include <stdio.h>
/* inpoly x y x1 y1 x2 y2 x3 y3 ... xn yn
 * returns whether or not (x,y) is in the polygon with the specified corners.
 */
#define MAX 10

main(int argc, char *argv[])
{
  int x[MAX], y[MAX], a[MAX], b[MAX], c[MAX];
  int corners,count,index, same,cx,cy;
 
  if ((argc < 9) || (argc % 2 != 1) || (argc > MAX * 2 + 1)) { 
        printf("no\n");
        exit(2); }
  corners = 0;
  for (count=1; count<argc; count += 2) {
      sscanf(argv[count],"%d",x+corners);
      sscanf(argv[count+1],"%d",y+corners);
      corners++;
      }
  corners--;
  /* (x,y) is index 0, other points are other indices up to corners */
  /* now calculate gradients of sides of poly */
  cx = 0;
  cy = 0;
  for (index=1;index<=corners;index++) {
      int next = (index % corners) + 1;
      cx += x[index];
      cy += y[index];
      /* approximate vertical lines */
      a[index] = y[next] - y[index];
      b[index] = x[index] - x[next];
      c[index] = - (a[index]*x[index] + b[index]*y[index]);
      }
  cx = cx/corners;
  cy = cy/corners;
  same = 0;
  for (index=1;index<=corners;index++) {
      int p = a[index]*x[0] + b[index]*y[0] + c[index];
      int d = a[index]*cx + b[index]*cy + c[index];
      if ((d >= 0) && (p > 0)) same++;
      if ((d <= 0) && (p < 0)) same++;
      if ((d == 0) && (p == 0)) same++;
      }
  if (same == corners) { 
      printf("yes\n");
      exit(0); 
      }
    else { 
      printf("no\n");
      exit(1); 
      }
}

