# gateway.pl -- HTTP gateway with document caching
#
# gateway.pl,v 1.1 1994/11/11 06:19:28 sanders Exp
#
# very start of a proxy system, doesn't currently work though
#
# Tony Sanders, Oct 1993
#

package gateway;

# chop($hostname = `hostname`); # FQDName
$method = "GET";

sub main'do_gateway {
    local($path, $query) = @_;
    local($url) = &main'printable($path);
    $url .= "?" . $query if defined $query;
    local($host, $port, $path);

    undef $1; undef $2; undef $3;

    # http://host[:port][/path]
    # $url =~ m#^http://([^:/]+):*(\d*)(.*)#;

    # www.server[:port][/path]
    $url =~ m#^([^:/]+):*(\d*)(.*)#;
    $host = $1 || &main'error('bad_request', "Invalid URL: $url");
    $port = $2 || 80;
    $path = $3 || "/";

    $FD = &cache_open($host, $port, $path);
    &main'raw_fd($FD, STDOUT);
    close($FD); close(STDOUT);
    exit 0;
}

sub connect_client {
    local($fd, $port, $proto, $thisaddr, $thataddr) = @_;
    $proto = (getprotobyname($proto))[2] || die "getproto: $proto: $!";
    socket($fd, &main'AF_INET, &main'SOCK_STREAM, $proto) || die "socket: $!";
    setsockopt($fd, &main'SOL_SOCKET, &main'SO_REUSEADDR, pack("l", 1));
    local($this) = pack($main'sockaddr, &main'AF_INET, 0, $thisaddr);
    bind($fd, $this) || die "bind: $!";
    local($that) = pack($main'sockaddr, &main'AF_INET, $port, $thataddr);
    connect($fd, $that) || die "connect: $!";
    select((select($fd), $| = 1)[0]);
}

# returns $FD of the open cached file.
sub cache_open {
    local($host, $port, $path) = @_;
    local($FD) = "gateway'CACHEFD";
    local($counter) = "__counter__";

    ### XXX: should cache %cache if we can.
    dbmopen(%cache, "gateway/cache", 0664) || die "cache failure: $!";
    ### XXX: should diropen() and rebuild the cache
    ### Should store the URL as the first line of each cache file so
    ### we can rebuild the cache should something happen.
    ### XXX: Ouch, what happens when one client uses HTTP/1.0 and not another
    ### XXX: I hope I can get away without caching two versions of the data
    ### XXX: I'll probably punt and just return the data, skipping the headers
    ### XXX: Not to mention different language, encoding, etc.
    ### XXX: For now we ignore the problems.  Works for one person anyway
    if (! defined $cache{$host, $port, $path}) {
	$cache{$counter} = 'cf000000' unless defined $cache{$counter};
	$cache{$counter}++;
	local($CACHE) = "gateway'CACHE";
	&main'debug("caching http://$host:$port$path\n");
	$thisaddr = (gethostbyname($main'hostname))[4] || die "gethostbyname: $main'hostname: $!";
	$thataddr = (gethostbyname($host))[4] || die "gethostbyname: $host: $!";
	&connect_client($FD, $port, 'tcp', $thisaddr, $thataddr);
	local($select) = select($FD); $| = 1;
	    $method =~ y/a-z/A-Z/; $main'version =~ y/a-z/A-Z/;
	    print $method, " ", $path;
	    print " ", $main'version if $main'version;
	    print "\r\n";
	    ### XXX: Need to handle ECONNRESET and SIGPIPE
	    # Pass on the headers we recieved
	    &main'unparse_headers(*main'in_headers) if $main'version;
	    print "\r\n" if $main'version;
	select($select);
        # Set the cache so it's reopened below
        $cache{$host, $port, $path} = "gateway/" . $cache{$counter};
        # Dump everything into the cache file, including headers if any.
        open($CACHE, "> " . $cache{$host, $port, $path}) || die "cache failure: $!";
        &main'raw_fd($FD, $CACHE);
        close($FD); close($CACHE);
    }
    ### XXX: should recover somehow and log error
    &main'safeopen($FD, $cache{$host, $port, $path}) || die "cache failure: !$";
    dbmclose(%cache);
    # Return the opened $FD, skip past the first line when URL is present
    return $FD;
}
