# date.pl -- date/time gateway
#
# date.pl,v 2.7 1994/06/23 05:42:49 sanders Exp
#
# Tony Sanders <sanders@earth.com>, April 1993

package date;

sub main'do_date {
    local($timezone) = @_;
    local($tz) = $tzdir . "/" . ($timezone || "GMT");
    &main'error('bad_request', "Invalid Timezone: $timezone") unless -f $tz;

    local($TZ) = $main'ENV{'TZ'};		# save and restore timezone
    $main'ENV{'TZ'} = $tz;

    local($date);
    chop($date = `$cmd`);

    &main'MIME_header('ok', 'text/html');
    print "<HEAD>\n<ISINDEX>\n<TITLE>Date and Time Gateway</TITLE>\n</HEAD>\n";
    print "<BODY>\n<H1>$date</H1>\n";
    print "Timezone: $main'ENV{'TZ'} <P>\n";
    print '
Search on a timezone to get the date for that timezone. <P>
Use GMT offsets if all else fails (e.g., GMT-6). <P>
<H2>Available Timezones</H2>
<PRE>
Australia:    Canada:               US:               MISC:
 <A HREF="/date?Australia/LHI">LHI</A>           <A HREF="/date?Canada/Atlantic">Atlantic</A>              <A HREF="/date?US/Alaska">Alaska</A>            <A HREF="/date?CET">CET</A>         <A HREF="/date?Cuba">Cuba</A> 
 <A HREF="/date?Australia/NSW">NSW</A>           <A HREF="/date?Canada/Central">Central</A>               <A HREF="/date?US/Aleutian">Aleutian</A>          <A HREF="/date?EET">EET</A>         <A HREF="/date?Egypt">Egypt</A> 
 <A HREF="/date?Australia/North">North</A>         <A HREF="/date?Canada/East-Saskatchewan">East-Saskatchewan</A>     <A HREF="/date?US/Arizona">Arizona</A>           <A HREF="/date?GB-Eire">GB-Eire</A>     <A HREF="/date?Greenwich">Greenwich</A> 
 <A HREF="/date?Australia/Queensland">Queensland</A>    <A HREF="/date?Canada/Eastern">Eastern</A>               <A HREF="/date?US/Central">Central</A>           <A HREF="/date?Hongkong">Hongkong</A>    <A HREF="/date?Iceland">Iceland</A> 
 <A HREF="/date?Australia/South">South</A>         <A HREF="/date?Canada/Mountain">Mountain</A>              <A HREF="/date?US/East-Indiana">East-Indiana</A>      <A HREF="/date?Iran">Iran</A>        <A HREF="/date?Israel">Israel</A> 
 <A HREF="/date?Australia/Tasmania">Tasmania</A>      <A HREF="/date?Canada/Newfoundland">Newfoundland</A>          <A HREF="/date?US/Eastern">Eastern</A>           <A HREF="/date?Jamaica">Jamaica</A>     <A HREF="/date?Japan">Japan</A> 
 <A HREF="/date?Australia/Victoria">Victoria</A>      <A HREF="/date?Canada/Pacific">Pacific</A>               <A HREF="/date?US/Hawaii">Hawaii</A>            <A HREF="/date?Libya">Libya</A>       <A HREF="/date?MET">MET</A> 
 <A HREF="/date?Australia/West">West</A>          <A HREF="/date?Canada/Yukon">Yukon</A>                 <A HREF="/date?US/Michigan">Michigan</A>          <A HREF="/date?NZ">NZ</A>          <A HREF="/date?Navajo">Navajo</A> 
 <A HREF="/date?Australia/Yancowinna">Yancowinna</A>                          <A HREF="/date?US/Mountain">Mountain</A>          <A HREF="/date?PRC">PRC</A>         <A HREF="/date?Poland">Poland</A> 
                                     <A HREF="/date?US/Pacific">Pacific</A>           <A HREF="/date?ROC">ROC</A>         <A HREF="/date?ROK">ROK</A> 
Brazil:     Chile:        Mexico:    <A HREF="/date?US/Samoa">Samoa</A>             <A HREF="/date?Singapore">Singapore</A>   <A HREF="/date?Turkey">Turkey</A> 
 <A HREF="/date?Brazil/Acre">Acre</A>        <A HREF="/date?Chile/Continental">Continental</A>   <A HREF="/date?Mexico/BajaNorte">BajaNorte</A>                   <A HREF="/date?W-SU">W-SU</A>        <A HREF="/date?WET">WET</A> 
 <A HREF="/date?Brazil/DeNoronha">DeNoronha</A>   <A HREF="/date?Chile/EasterIsland">EasterIsland</A>  <A HREF="/date?Mexico/BajaSur">BajaSur</A> 
 <A HREF="/date?Brazil/East">East</A>                      <A HREF="/date?Mexico/General">General</A> 
 <A HREF="/date?Brazil/West">West</A> 
</PRE>
</BODY>
';
    $main'ENV{'TZ'} = $TZ;
}

1;
