/*********************************************************************/
/*
 * Motif Interface to the WAIS protocol
 *
 * Paul Leclerc
 * pel@ctron.com
 *
 */
/*********************************************************************/
#include <stdio.h>
#include <malloc.h>
#include <X11/Intrinsic.h>
#include <X11/Shell.h>
#include <X11/StringDefs.h>
#include <Xm/Xm.h>
#include <Xm/List.h>
#include <Xm/Form.h>
#include <Xm/PushB.h>
#include <Xm/Separator.h>
#include <Xm/Label.h>
#include <Xm/Text.h>
/*********************************************************************/
/*                         Resource Setup                            */
/*********************************************************************/
String fallback_resources[] = {
    "*title*fontList:			*-times-bold-r-*-*-*-140-*" ,
    "*textwindow.rows:			24",
    "*textwindow.columns:		80",
    "*sidelist.visibleItemCount:	12",
    NULL,
};

typedef struct {
    char	*server;
    int		service;
    char	*db;
    int		maxdocs;
} Data, *DataPtr;
	
static XtResource resources[] = {
{"server", "Server", XmRString, sizeof(String),
     XtOffset(DataPtr,server),
     XmRString, "quake.think.com"},
{"service", "Service", XmRInt, sizeof(int),
     XtOffset(DataPtr,service),
     XmRString, "210"},
{"maxdocs", "Maxdocs", XmRInt, sizeof(int),
     XtOffset(DataPtr,maxdocs),
     XmRString, "100"},
{"db", "Db", XmRString, sizeof(String),
     XtOffset(DataPtr,db),
     XmRString, "directory-of-servers"}
};

Data	resdata;
/*********************************************************************/
Widget toplevel;
Widget baseform;
Widget scrolltext;
Widget hitform;
Widget hitlist;
Widget docwin;

Widget servertext,dbtext,querytext,servicetext;

static char *server, *db, *query;
int service;
char mesgtxt[512];
FILE *logfile = NULL;

unsigned long global_argc;
char **global_argv;
/*********************************************************************/
void static StartQuery( );
void print_message( );
void PrintDocWin( );
static void CreateUI( );
static void CreateHitUI( );
static void Quit( );
static void SelectDoc( );
extern char* s_strdup();

char *log_file_name = NULL;
FILE* log_file = NULL;

/*********************************************************************/
main(argc, argv)
int argc;
char *argv[];
{
    XtAppContext app_con;

    server = db = query = NULL;

    toplevel = XtAppInitialize(&app_con, "MXwais", NULL, 0,
			       &argc, argv, fallback_resources, NULL, 0);
    global_argc = argc;
    global_argv = argv;

    XtGetApplicationResources(toplevel, &resdata, resources,
			      XtNumber(resources), NULL, 0);

    if( resdata.service )
	service = resdata.service;
    if( resdata.server )
	server = s_strdup( resdata.server );
    if( resdata.db )
	db = s_strdup( resdata.db );

    CreateUI( toplevel );
    CreateHitUI( toplevel );

    XtRealizeWidget(toplevel);
    XtAppMainLoop(app_con);
}
/*********************************************************************/
/* Main window for MXwais                                            */
/*********************************************************************/
static void CreateUI( top )
Widget	top;
{
    Arg	args[15];
    int	num;

    Widget button;
    Widget label1,label2,label3,label4;
    Widget form1,form2,form3,form4;
    Widget sep1,sep2;
    Widget querybutton;
    Widget quitbutton;
    XmString strn;
    char servstr[10];

    sprintf( servstr,"%d",service);
    num = 0;
    baseform = XmCreateForm( top, "topform", args, num );
    XtManageChild( baseform );

    num = 0;
    XtSetArg( args[num], XmNtopAttachment, XmATTACH_FORM); num++;    
    XtSetArg( args[num], XmNrightPosition, 40); num++;
    XtSetArg( args[num], XmNrightAttachment, XmATTACH_POSITION); num++;
    form1 = XmCreateForm( baseform, "serverform", args, num );
    XtManageChild( form1 );

    num = 0;
    strn = XmStringCreateSimple("Server:");
    XtSetArg( args[num], XmNlabelString, strn); num++;
    XtSetArg( args[num], XmNbottomAttachment, XmATTACH_FORM); num++;
    XtSetArg( args[num], XmNtopAttachment, XmATTACH_FORM); num++;    
    XtSetArg( args[num], XmNleftAttachment, XmATTACH_FORM); num++;
    label1 = XtCreateManagedWidget("serverlabel", xmLabelWidgetClass, form1,
				   args,num);
    XmStringFree( strn );

    num = 0;
    XtSetArg( args[num], XmNbottomAttachment, XmATTACH_FORM); num++;
    XtSetArg( args[num], XmNtopAttachment, XmATTACH_FORM); num++;
    XtSetArg( args[num], XmNleftWidget, label1); num++;
    XtSetArg( args[num], XmNleftAttachment, XmATTACH_WIDGET); num++;
    XtSetArg( args[num], XmNvalue, server); num++;
    servertext = XtCreateManagedWidget("servertext", xmTextWidgetClass, form1,
				       args,num);

    /* Form #2   Database field */
    num = 0;
    XtSetArg( args[num], XmNrightPosition, 40); num++;
    XtSetArg( args[num], XmNrightAttachment, XmATTACH_POSITION); num++;
    XtSetArg( args[num], XmNtopWidget, form1); num++;
    XtSetArg( args[num], XmNtopAttachment, XmATTACH_WIDGET); num++;
    form2 = XmCreateForm( baseform, "dbform", args, num );
    XtManageChild( form2 );

    num = 0;
    strn = XmStringCreateSimple("Database:");
    XtSetArg( args[num], XmNlabelString, strn); num++;
    XtSetArg( args[num], XmNtopAttachment, XmATTACH_FORM); num++;
    XtSetArg( args[num], XmNbottomAttachment, XmATTACH_FORM); num++;
    XtSetArg( args[num], XmNleftAttachment, XmATTACH_FORM); num++;
    XtSetArg( args[num], XmNvalue, db); num++;
    label2 = XtCreateManagedWidget("dblabel", xmLabelWidgetClass, form2,
			       args,num);
    XmStringFree( strn );
    num = 0;
    XtSetArg( args[num], XmNtopAttachment, XmATTACH_FORM); num++;
    XtSetArg( args[num], XmNbottomAttachment, XmATTACH_FORM); num++;
    XtSetArg( args[num], XmNleftWidget, label2); num++;
    XtSetArg( args[num], XmNleftAttachment, XmATTACH_WIDGET); num++;
    XtSetArg( args[num], XmNvalue, db); num++;
    dbtext = XtCreateManagedWidget("dbtext", xmTextWidgetClass, form2,
				   args,num);

    /* Form #3   Query field */
    num = 0;
    XtSetArg( args[num], XmNrightPosition, 40); num++;
    XtSetArg( args[num], XmNrightAttachment, XmATTACH_POSITION); num++;
    XtSetArg( args[num], XmNtopWidget, form2); num++;
    XtSetArg( args[num], XmNtopAttachment, XmATTACH_WIDGET); num++;
    form3 = XmCreateForm( baseform, "dbform", args, num );
    XtManageChild( form3 );

    num = 0;
    strn = XmStringCreateSimple("Query:");
    XtSetArg( args[num], XmNlabelString, strn); num++;
    XtSetArg( args[num], XmNbottomAttachment, XmATTACH_FORM); num++;
    XtSetArg( args[num], XmNtopAttachment, XmATTACH_FORM); num++;    
    XtSetArg( args[num], XmNleftAttachment, XmATTACH_FORM); num++;
    label3 = XtCreateManagedWidget("querylabel", xmLabelWidgetClass, form3,
				   args,num);
    XmStringFree( strn );

    num = 0;
    XtSetArg( args[num], XmNbottomAttachment, XmATTACH_FORM); num++;
    XtSetArg( args[num], XmNtopAttachment, XmATTACH_WIDGET); num++;
    XtSetArg( args[num], XmNleftWidget, label3); num++;
    XtSetArg( args[num], XmNleftAttachment, XmATTACH_WIDGET); num++;
    querytext = XtCreateManagedWidget("querytext", xmTextWidgetClass, form3,
				      args,num);

    /* Form #4   Service field */
    num = 0;
    XtSetArg( args[num], XmNrightPosition, 40); num++;
    XtSetArg( args[num], XmNrightAttachment, XmATTACH_POSITION); num++;
    XtSetArg( args[num], XmNtopWidget, form3); num++;
    XtSetArg( args[num], XmNtopAttachment, XmATTACH_WIDGET); num++;
    form4 = XmCreateForm( baseform, "dbform", args, num );
    XtManageChild( form4 );

    num = 0;
    strn = XmStringCreateSimple("Service:");
    XtSetArg( args[num], XmNlabelString, strn); num++;
    XtSetArg( args[num], XmNbottomAttachment, XmATTACH_FORM); num++;
    XtSetArg( args[num], XmNtopAttachment, XmATTACH_FORM); num++;    
    XtSetArg( args[num], XmNleftAttachment, XmATTACH_FORM); num++;
    label3 = XtCreateManagedWidget("querylabel", xmLabelWidgetClass, form4,
				   args,num);
    XmStringFree( strn );

    num = 0;
    XtSetArg( args[num], XmNbottomAttachment, XmATTACH_FORM); num++;
    XtSetArg( args[num], XmNtopAttachment, XmATTACH_WIDGET); num++;
    XtSetArg( args[num], XmNleftWidget, label3); num++;
    XtSetArg( args[num], XmNleftAttachment, XmATTACH_WIDGET); num++;
    XtSetArg( args[num], XmNvalue, servstr); num++;
    servicetext = XtCreateManagedWidget("servicetext", xmTextWidgetClass,
					form4, args, num);

    num = 0;
    XtSetArg( args[num], XmNleftAttachment, XmATTACH_FORM); num++;
    XtSetArg( args[num], XmNrightAttachment, XmATTACH_FORM); num++;
    XtSetArg(args[num], XmNtopWidget, form4); num++;
    XtSetArg(args[num], XmNtopAttachment, XmATTACH_WIDGET); num++;
    sep1 = XtCreateManagedWidget("separator",xmSeparatorWidgetClass, baseform,
				   args, num);

    /* Query button */
    num = 0;
    strn = XmStringCreateSimple("Start Query");
    XtSetArg( args[num], XmNlabelString, strn); num++;
    XtSetArg( args[num], XmNtopWidget, sep1 ); num++;
    XtSetArg( args[num], XmNtopAttachment, XmATTACH_WIDGET); num++;
    XtSetArg( args[num], XmNleftAttachment, XmATTACH_POSITION); num++;
    XtSetArg( args[num], XmNleftPosition, 25); num++;
    querybutton = XtCreateManagedWidget("querybutton", xmPushButtonWidgetClass,
					baseform, args, num);
    XtAddCallback(querybutton, XmNactivateCallback,
		  (XtCallbackProc)StartQuery, NULL );
    XmStringFree( strn );

    /* Quit button */
    num = 0;
    strn = XmStringCreateSimple("Quit");
    XtSetArg( args[num], XmNlabelString, strn); num++;
    XtSetArg( args[num], XmNtopWidget, sep1 ); num++;
    XtSetArg( args[num], XmNtopAttachment, XmATTACH_WIDGET); num++;
    XtSetArg( args[num], XmNleftAttachment, XmATTACH_POSITION); num++;
    XtSetArg( args[num], XmNleftPosition, 65); num++;
    quitbutton = XtCreateManagedWidget("quitbutton", xmPushButtonWidgetClass,
					baseform, args, num);
    XtAddCallback(quitbutton, XmNactivateCallback,
		  (XtCallbackProc)Quit, NULL );
    XmStringFree( strn );
    
    num = 0;
    XtSetArg( args[num], XmNleftAttachment, XmATTACH_FORM); num++;
    XtSetArg( args[num], XmNrightAttachment, XmATTACH_FORM); num++;
    XtSetArg(args[num], XmNtopWidget, querybutton); num++;
    XtSetArg(args[num], XmNtopAttachment, XmATTACH_WIDGET); num++;
    sep2 = XtCreateManagedWidget("separator",xmSeparatorWidgetClass, baseform,
				   args,num);
    num = 0;
    XtSetArg(args[num], XmNbottomAttachment, XmATTACH_FORM); num++;
    XtSetArg(args[num], XmNtopWidget, sep2); num++;
    XtSetArg(args[num], XmNtopAttachment, XmATTACH_WIDGET); num++;
    XtSetArg(args[num], XmNeditMode, XmMULTI_LINE_EDIT); num++;
    XtSetArg(args[num], XmNscrollBarPlacement,XmBOTTOM_RIGHT); num++;
    XtSetArg(args[num], XmNleftAttachment, XmATTACH_FORM); num++;
    XtSetArg(args[num], XmNrightAttachment, XmATTACH_FORM); num++;
    XtSetArg(args[num], XmNrows, 10); num++;
    scrolltext = XmCreateScrolledText(baseform, "textwindow", args, num);
    XtManageChild(scrolltext);

}
/*********************************************************************/
/* This window contains a scrolled list and text window in which
 * you double click on a "hit" and can see the text from that document
 */
/*********************************************************************/
static void CreateHitUI( top )
Widget top;
{
    Arg		args[15];
    int		num;
    XmString	strn;


    strn = XmStringCreateSimple("Hit List");
    num = 0;
    XtSetArg( args[num], XmNautoUnmanage, FALSE); num++;
    XtSetArg( args[num], XmNdialogTitle, strn); num++;
    hitform = XmCreateFormDialog(top, "hitform", args, num);
    XmStringFree(strn);

    num = 0;
    XtSetArg( args[num], XmNtopAttachment, XmATTACH_FORM); num++;    
    XtSetArg( args[num], XmNselectionPolicy, XmSINGLE_SELECT); num++;
    XtSetArg( args[num], XmNvisibleItemCount, 10); num++;
    XtSetArg(args[num], XmNleftAttachment, XmATTACH_FORM); num++;
    XtSetArg(args[num], XmNrightAttachment, XmATTACH_FORM); num++;
    hitlist = XmCreateScrolledList(hitform, "hitwin", args, num);
    XtAddCallback( hitlist, XmNdefaultActionCallback,
		  (XtCallbackProc)SelectDoc, NULL );
    XtManageChild( hitlist );

    num = 0;
    XtSetArg(args[num], XmNtopWidget, hitlist); num++;
    XtSetArg(args[num], XmNtopAttachment, XmATTACH_WIDGET); num++;
    XtSetArg(args[num], XmNeditMode, XmMULTI_LINE_EDIT); num++;
    XtSetArg(args[num], XmNscrollBarPlacement,XmBOTTOM_RIGHT); num++;
    XtSetArg(args[num], XmNleftAttachment, XmATTACH_FORM); num++;
    XtSetArg(args[num], XmNrightAttachment, XmATTACH_FORM); num++;
    XtSetArg(args[num], XmNrows, 20); num++;
    docwin = XmCreateScrolledText(hitform, "textwindow", args, num);
    XtManageChild(docwin);

    XtManageChild( hitform );
}

/*********************************************************************/
void ClearHits( )
{
    XmListDeleteAllItems( hitlist );
}
/*********************************************************************/
/* Add a new hit to the end of the list				     */
void AddHit( str )
char	*str;
{
    XmString strn;

    strn = XmStringCreateSimple( str );
    XmListAddItem( hitlist, strn, 0);
    XmStringFree( strn );
}
/*********************************************************************/
static void SelectDoc( w, data, cb)
Widget w;
caddr_t data;
XmListCallbackStruct *cb;
{
#ifdef DODEBUG
    printf("SelectDoc: %d doc selected\n",cb->item_position);
#endif
    DisplayDocNum( cb->item_position,db );
}
/*********************************************************************/
static void Quit( w, data, cb)
Widget w;
caddr_t data;
XmPushButtonCallbackStruct *cb;
{
    /* We probably should do more but??? */
    exit( 1 );
}
/*********************************************************************/
/* This routine gathers the info from the text fields and passes
 * the information to the routine to do the real work.
 */
static void StartQuery( w, data, cb)
Widget w;
caddr_t data;
XmPushButtonCallbackStruct *cb;
{
    char	*serverstring;
    char	*dbstring;
    char	*querystring;
    char	*servicestring;

    serverstring = XmTextGetString( servertext );
    if( serverstring )
    {
	if( server )
	    free( server );
	server = serverstring;
    }
    else
    {
	print_message("No server defined\n");
    }

    dbstring = XmTextGetString( dbtext );
    if( dbstring )
    {
	if( db )
	    free( db );
	db = dbstring;
    }

    servicestring = XmTextGetString( servicetext );
    if( servicestring )
    {
	service = atoi(servicestring);
    }

    querystring = XmTextGetString( querytext );
    if( querystring )
    {
	if( query )
	    free( query );
	query = querystring;
    }

    /* Do the actual search... */
    PerformSearch( server, db, query, service, resdata.maxdocs );
}
/*********************************************************************/
/* Print a message to the scrolled text window			     */
/*********************************************************************/
void print_message(str)
char * str;
{
    int	lastpos;
    
    lastpos = XmTextGetLastPosition(scrolltext);
    
    XmTextReplace(scrolltext,lastpos,lastpos,str);
    XmTextSetInsertionPosition(scrolltext,lastpos);
}
/*********************************************************************/
/* Clear the text window to prepare for a new document coming in     */
/*********************************************************************/
void ClearDocWin( )
{

    char *spaces = " ";
    int	lastpos;
    
    lastpos = XmTextGetLastPosition(docwin);
    
    XmTextReplace(docwin,0,lastpos,spaces);
    XmTextSetInsertionPosition(docwin,0);
}
/*********************************************************************/
/* Print the buffer to the text window setup to view the incoming doc*/
/*********************************************************************/
void PrintDocWin( buf )
char	buf[];
{
    int	lastpos;
    
    lastpos = XmTextGetLastPosition(docwin);
    
    XmTextReplace(docwin,lastpos,lastpos,buf);
}
/*********************************************************************/
