/*
 * Copyright (c) 1989, 1990, 1991 by the University of Washington
 *
 * For copying and distribution information, please see the file
 * <uw-copyright.h>.
 */

#include <uw-copyright.h>
#include <stdio.h>

#include <perrno.h>

int	pfs_debug = 0;

main(argc,argv)
    int 	argc;
    char	*argv[];
    {
	char	*progname;
	int	tmp;

	progname = argv[0];
	argc--;argv++;

	while (argc > 0 && **argv == '-') {
	    switch (*(argv[0]+1)) {
		
	    case 'D':
		pfs_debug = 1; /* Default debug level */
		sscanf(argv[0],"-D%d",&pfs_debug);
		break;

	    case '-': /* -- means stop scanning options */
		argc--, argv++;
		goto scandone;

	    default:
		fprintf(stderr,"Usage: vrm link\n");
		exit(1);
	    }
	    argc--, argv++;
	}

    scandone:

	if(argc != 1) {
	    fprintf(stderr,"Usage: vrm link\n");
	    exit(1);
	}

	tmp = del_vlink(argv[0],0);

	if(tmp) {
	    fprintf(stderr,"%s failed: %s\n",progname,p_err_text[tmp]);
	    exit(1);
	}

	exit(0);
    }
