/*
 * Copyright (c) 1989, 1990 by the University of Washington
 *
 * For copying and distribution information, please see the file
 * <uw-copyright.h>.
 */

#include <uw-copyright.h>
#include <stdio.h>

#include <pfs.h>
#include <perrno.h>

int	perrno;
int	pfs_debug = 0;

PATTRIB		pget_at();

main(argc,argv)
    int		argc;
    char	*argv[];
    {
	VDIR_ST		dir_st;
	VDIR		dir= &dir_st;
	VLINK		l;
	VLINK		replica;
	int		flags = 0;
	int		verbose = 0;
	int		dmagic = 0;
	int		show_failed = 0;
	int		show_at = 0;
	int		replica_flag = 0;
	int		conflict_flag = 0;
	int		tmp;
	char		at_name[40];
	char		*progname = argv[0];

	flags = GVD_LREMEXP;

	vdir_init(dir);

	argc--;argv++;

	while (argc > 0 && **argv == '-') {
	    switch (*(argv[0]+1)) {
		
	    case 'a':  /* Show attributes */
		show_at = 1; 
		verbose = 1;
		tmp = sscanf(argv[0],"-a%s",at_name);
		if((tmp < 1) || (*at_name == '\0'))  strcpy(at_name,"ALL");
		break;

	    case 'A':  /* Show only link attributes */
		show_at = 2; /* Show only link attributes */
		verbose = 1;
		tmp = sscanf(argv[0],"-a%s",at_name);
		if((tmp < 1) || (*at_name == '\0'))  strcpy(at_name,"ALL");
		break;

	    case 'c':  /* Show conflicting links */
		conflict_flag++;
		break;

	    case 'D':  /* Debug level */
		pfs_debug = 1; /* Default debug level */
		sscanf(argv[0],"-D%d",&pfs_debug);
		break;

	    case 'f':  /* Show failed links */
		show_failed++;
		break;

	    case 'm':  /* Display magic number */
		dmagic++;
		break;

	    case 'r':  /* Show replicas */
		replica_flag++;
		break;

	    case 'u':  /* Do not expand union links */
		flags = GVD_UNION;
		break;

	    case 'v':  /* Display link on more than one line (verbose) */
		verbose = 1;
		break;

	    default:
		fprintf(stderr,
			"Usage: vls [-a,-c,-r,-u,-v] <file or directory name>\n");
		exit(1);
	    }
	    argc--, argv++;
	}

	if(show_at) flags |= GVD_ATTRIB;

	if (argc > 1) {
	    fprintf(stderr,
		    "Usage: vls [-a,-c,-r,-u,-v] <file or directory name>\n");
	    exit(1);
	}

	tmp = rd_vdir((argc == 1 ? argv[0] : ""),0,dir,flags);

	if(tmp && (tmp != DIRSRV_NOT_DIRECTORY)) {
	    fprintf(stderr,"%s failed: %s\n",progname,p_err_text[tmp]);
	    exit(1);
	}

	l = dir->links;

	while(l) {
	    display_link(l,dmagic,verbose,show_at,at_name);
	    replica = l->replicas;
	    while(replica) {
		if((replica_flag && (l->f_magic_no != 0) && 
		    (l->f_magic_no == replica->f_magic_no)) || conflict_flag)
		    display_link(replica,
			 (dmagic || (l->f_magic_no != replica->f_magic_no)),
			 verbose,show_at,at_name);
		replica = replica->next;
	    }
	    l = l->next;
	}

	l = dir->ulinks;

	if((tmp != DIRSRV_NOT_DIRECTORY) || show_failed) {
	    while(l) {
		if((l->expanded == FALSE) || (l->expanded == FAILED))
		display_link(l,dmagic,verbose,show_at,at_name);
		l = l->next;
	    }
	}

	vllfree(dir->links);
	exit(0);

    }


display_link(l,dmagic,verbose,show_at,at_name)
    VLINK	l;
    int		dmagic;
    int		verbose;
    int		show_at;
    char	*at_name;
    {
	VLINK		fil;
	PATTRIB 	ap;
	char		linkname[MAX_VPATH];

	
	if(l->linktype == '-') return;

	if(dmagic) sprintf(linkname,"%s#%d",l->name,l->f_magic_no);
	else strcpy(linkname,l->name);

	if (verbose) {
	    printf("\n      Name: %s\n",l->name);
	    printf("   ObjType: %s\n",l->type);
	    printf("  LinkType: %s\n",((l->linktype == 'U') ? "Union" : "Standard"));
	    printf("  HostType: %s\n",l->hosttype);
	    printf("      Host: %s\n",l->host);
	    printf("  NameType: %s\n",l->nametype);
	    printf("  Pathname: %s\n",l->filename);
	    if(l->version) printf("   Version: %d\n",l->version);
	    if(dmagic || l->f_magic_no) 
		printf("     Magic: %d\n",l->f_magic_no);

	    if(show_at) {
		/* If only link attributes, then use l->lattrib */
		/* otherwise get attribues for object.          */
		if(show_at == 2) ap = l->lattrib;
		else {
		    /* Eventually we will merge the link attributes with  */
		    /* the object attribues based on the precedence field,*/
		    /* but for now, if attributes are retruend for the    */
		    /* object we use them, otherwisseise we use those     */
		    /* associated with the link                           */
		    ap = pget_at(l,at_name);
		    if(!ap) ap = l->lattrib;
		}
		if(ap) {
		    printf("Attributes:\n\n");
		    while(ap) {
			printf("%15s: ",ap->aname);
			if(strcmp(ap->avtype,"ASCII") == 0)
			    printf("%s\n",ap->value.ascii);
			else if(strcmp(ap->avtype,"LINK") == 0)
			    printf("%s %s %s %d %d\n",
				   ap->value.link->name,ap->value.link->host,
				   ap->value.link->filename,
				   ap->value.link->version, 
				   ap->value.link->f_magic_no);
			else printf("<unknown-type %s>\n",ap->avtype);
			ap = ap->next;
		    }
		    printf("\n");
		}
		atlfree(ap);
	    }

	    if(l->filters) {
		printf("   Filters: \n");
		fil = l->filters;
		while(fil) {
		    printf("\n      HostType: %s\n",fil->hosttype);
		    printf("          Host: %s\n",fil->host);
		    printf("      NameType: %s\n",fil->nametype);
		    printf("      Pathname: %s\n",fil->filename);
		    if(fil->f_magic_no) 
			printf("         Magic: %d\n",fil->f_magic_no);
		    if(fil->args) printf("          Args: %s\n",fil->args);
		    fil = fil->next;
		}
	    }
	    printf("\n");
	}
	else printf("%c%c %-20.20s %c%-15.15s %-38.38s\n",
		    ((l->linktype == 'L') ? ' ' : l->linktype),
		    (l->expanded ? 'F' : ' '),
		    linkname,
		    (l->filters ? '*' : ' '),
		    l->host,l->filename);
	
    }
