/*
 * Copyright (c) 1989, 1990, 1991 by the University of Washington
 *
 * For copying and distribution information, please see the file
 * <uw-copyright.h>.
 */

#include <uw-copyright.h>
#include <stdio.h>
#include <strings.h>

#include <pfs.h>
#include <perrno.h>
#include <pmachine.h>

int	perrno;
int	pfs_debug = 0;

main(argc,argv)
    int		argc;
    char	*argv[];
    {
	char		*progname;

	int		flags = 0;       /* Union, etc.                   */
	int		symbolic = 0;    /* Symbolic option               */
	int		native = 0;      /* Native options                */
	int		message = 0;     /* Read Virt filename from stdin */
	int		nm2notdir = 0;   /* Do not treat nm2 as a dir     */
	int		customize = 0;   /* Customizing current view      */
	int		avsflag = 0;     /* Use active VS (no closure)    */
	char		closure[MAX_VPATH];

	char		hst[MAX_VPATH];	 /* Host name                     */
	char		nm1[MAX_VPATH];	 /* Name of object to be linked   */
	char		nm2[MAX_VPATH];	 /* The new name for the object   */

	char		extp[MAX_VPATH]; /* Type of external access       */
	char		exst[MAX_VPATH]; /* Type string for ext access    */

	char		*nlnm;		 /* New link name                 */
	char		*ldir;		 /* Dir to get link               */
	VLINK		nl;              /* New link                      */

	int		tmp = 0;         /* Temp return value             */

	*closure = '\0';

	progname = argv[0];
	argc--;argv++;

	nl = vlalloc();

	while (argc > 0 && **argv == '-') {
	    switch (*(argv[0]+1)) {
		
	    case 'D':
		pfs_debug = 1; /* Default debug level */
		sscanf(argv[0],"-D%d",&pfs_debug);
		break;

 	    case 'a':
 		avsflag++;
 		break;

	    case 'c': 
		/* If customizing directory, then we do not want to find  */
		/* the link that is already in the union linked directory */
		customize++;
		nm2notdir++;
		break;

	    case 'e': 
		strcpy(extp,"AFTP,BINARY");
		sscanf(argv[0],"-e%s",extp);
		sprintf(exst,"EXTERNAL(%s)",extp),
		stfree(nl->type);		
		nl->type = stcopy(exst);
		stfree(nl->hosttype);		
		nl->hosttype = stcopy("INTERNET-D");
		/* If external, then the hostname must be provided */
		native++; 
		break;

	    case 'm':
		message++; 
		break;

	    case 'n':
		native++;
		break;

	    case 's':
		stfree(nl->type);		
		nl->type = stcopy("SYM-LINK");
		stfree(nl->hosttype);		
		nl->hosttype = stcopy("VIRTUAL-SYSTEM");
		symbolic++;
		break;

	    case 'u':
		flags = AVL_UNION;
		break;
		
	    default:
		fprintf(stderr,
			"Usage: vln [-a,-m,-s,-u] [-e,-n host] name1 [name2]\n");
		exit(1);
	    }
	    argc--, argv++;
	}


	/* I must still add support for allowing one to */
	/* specify the host type and id type and the    */
	/* link type with the native option             */

	/* if stdin is not a tty and OK to use closure */
	/* then we have to extract closure info        */
	if(!avsflag && !isatty(0)) {
	    char	*s;
	    s = readheader(stdin,"virtual-system-name:");
	    if(!s)  {
		fprintf(stderr,"Can't find Virtual-System-Name.\n");
		exit(1);
	    }
	    strcpy(closure,s);

	    /* And if the -m option was specified, read the rest to the */
	    /* file looking for te virtual file name.                   */
	    if(message) {
		s = readheader(stdin,"virtual-file-name:");
		if(!s) {
		    fprintf(stderr,"Can't find Virtual-file-name.\n");
		    exit(1);
		}
		if(*s == '/') s++;
		strcat(nm1,s);

	    }
	}
	/* If message option specified, but no stdin, that's an error */
	else if(message) {
	    fprintf(stderr,"vln: -m only works if input is redirected\n");
	    exit(1);
	}

	/* We need at least 1 argument + 1 for host if a native */
	/* link and less name1 if it is read from stdin         */
	if((argc < 1 + (native ? 1 : 0) - (message ? 1 : 0)) ||
	   (argc > 2 + (native ? 1 : 0) - (message ? 1 : 0))) {
	    fprintf(stderr,
		    "Usage: vln [-a,-m,-s,-u] [-e,-n host] name1 [name2]\n");
	    exit(1);
	}

	/* If a native link, then first argument is the hostname */
	if(native) {
	    strcpy(hst,argv[0]);
	    argc--;argv++;
	}
	/* If symbolic, but not native, host name is the virtual system name */
	else if (symbolic) {
	    char	*s;

	    if(*closure) s = closure;
	    else s = pget_vsname();

	    if(s) strcpy(hst,s);
	    else {
		fprintf(stderr,"vln: Environment not initialized - source vfsetup.source then run vfsetup");
		exit(1);
	    }

	}

	/* Read the first file name if it is required */
	if(!message) {
	    strcpy(nm1,argv[0]);
	    argc--;argv++;
	}

	/* If non native symlink, and if reltive to working dir, */
	/* prepend working directory                             */
	if(!native && symbolic && (*nm1 != '/')) {
	    char	temp[MAX_VPATH];
	    char	*wd;
	    wd = pget_wd();
	    if(!wd) {
		fprintf(stderr,"vln: Environment not initialized - source vfsetup.source then run vfsetup");
		exit(1);
	    }
	    sprintf(temp,"%s/%s",wd,nm1);
	    strcpy(nm1,temp);
	}
	
	/* If normal link and we have a closed namespace from */
	/* stdin, then make nm1 relative to closed namespace  */
	if(!native && !symbolic && *closure) {
	    char	temp[MAX_VPATH];
	    sprintf(temp,"%s:%s",closure,nm1);
	    strcpy(nm1,temp);
	}

	/* Assume second file name is a directory.  If null, then */
	/* it is the current working directory.                   */
	if(argc > 0) {
	    strcpy(nm2,argv[0]);
	    argc--;argv++;
	}
	else strcpy(nm2,"");

	/* Assume new link name is last component of nm1 */
	nlnm = rindex(nm1,'/');
	if(!nlnm && !(nlnm = rindex(nm1,':'))) nlnm = nm1;
	else nlnm++;

	/* If nm1 was either empty, or ended in / or :, must use last */
	/* component of nm2 as link name.  i.e. nm2 is not the        */
	/* directory                                                  */
	if(! *nlnm) nm2notdir++;

	/* If a symbolic or native, fill in fields */
	if(symbolic || native) {
	    nl->host = hst;
	    nl->filename = nm1;
	}
	/* Otherwise, resolve nm1                  */
	else {
	    vlfree(nl);
	    nl = rd_vlink(nm1);
	    if(!nl) {
		fprintf(stderr,"vlink: %s not found\n",nm1);
		exit(1);
	    }
	}

	/* If nm2 might be the name of the directory to use */
	if(!nm2notdir) tmp = add_vlink(nm2,nlnm,nl,flags);

	/* If not a directory, then the last component on nm2 is */
	/* the link name, and what precedes it is the dir name   */
	if (nm2notdir || (tmp == DIRSRV_NOT_DIRECTORY)) {
	    nlnm = rindex(nm2,'/');
	    if(!nlnm) {
		/* If nm2 is null, and the customize option was      */
		/* specified, then nm2 is the last component of nm1  */
		if(customize && (! *nm2)) {
		    nlnm = rindex(nm1,'/');
		    if(!nlnm) nlnm = nm1;
		}
		else nlnm = nm2;
		ldir = "";
	    }
	    else {
		if(! *(nlnm+1)) {
		    fprintf(stderr,"vln: invalid name %s\n",nm2);
		    exit(1);
		}
		*(nlnm++) = '\0';
		ldir = nm2;
	    }

	    /* Add it, this time in the parent directory */
	    tmp = add_vlink(ldir,nlnm,nl,flags);
	}

	if(tmp) {
	    fprintf(stderr,"%s failed: %s\n",progname,p_err_text[tmp]);
	    exit(1);
	}

	exit(0);
    }

