/*
 * Copyright (c) 1989, 1990, 1991 by the University of Washington
 *
 * For copying and distribution information, please see the file
 * <uw-copyright.h>.
 */

#include <uw-copyright.h>
#include <sys/param.h>
#include <sys/wait.h>
#include <strings.h>
#include <stdio.h>

#include <pfs.h>
#include <psite.h>
#include <perrno.h>
#include <pcompat.h>
#include <pmachine.h>

int	perrno;
int	pfs_debug = 0;


main(argc, argv)
    char *argv[];
    {
	char		am_args[MAX_PTXT_LEN];
	char		path[MAX_VPATH];
	char		vcachebin[MAXPATHLEN];
	char		*lclfil;
	char		*method;
	int		am;
	VLINK		vl;
	int 		pid;
	union wait 	status;

	int		message_option = 0;
	int		avsflag = 0;  /* If set - use active VS (no closure) */
	char		*debugflag = "-";
	char		*verboseflag = "-v";

	argc--;argv++;

	while (argc > 0 && *argv[0] == '-' && *(argv[0]+1) != '\0') {
	    switch (*(argv[0]+1)) {
		
	    case 'D':
		pfs_debug = 1; /* Default debug level */
		sscanf(argv[0],"-D%d",&pfs_debug);
		debugflag = argv[0];
		break;
				
 	    case 'a':
 		avsflag++;
 		break;

	    case 'm':
		message_option++; 
		break;
		
	    case 'q':
		verboseflag = "-";
		break;

	    case 'v':
		verboseflag = "-v";
		break;

	    default:
		fprintf(stderr,
			"Usage: vget [-a,-m,-q,-v] virtual-file [local-file]\n");
		exit(1);
	    }
	    argc--; argv++;
	}

 	/* The next argument must be the name of the file to retrieve */
 	/* within the virtual file system unless it is to extracted   */
	/* from a mail message                                        */

	if(argc < 1 && !message_option) {
	    fprintf(stderr,"Usage: vget [-a,-m,-q,-v] virtual-file [local-file]\n");
	    exit(1);
	}
	
	if (argc >= 1) strcpy(path,argv[0]);

	/* if stdin is not a tty and OK to use closure */
	/* then we have to extract closure info        */
	if(!avsflag && !isatty(0)) {
	    char	*s;
	    s = readheader(stdin,"virtual-system-name:");
	    if(!s)  {
		fprintf(stderr,"vget: Can't find Virtual-System-Name.\n");
		exit(1);
	    }
	    sprintf(path,"%s:",s);
		
	    if(message_option) {
		s = readheader(stdin,"virtual-file-name:");
		if(!s) {
		    fprintf(stderr,"vget: Can't find Virtual-file-name.\n");
		    exit(1);
		}
		strcat(path,s);
	    }
	    else strcat(path,argv[0]);

	}
	else if(message_option) {
	    fprintf(stderr,"vget: Can't find Virtual-file-name.\n");
	    exit(1);
	}

	/* If second name was not specified, derive it from first */
	if(argc == (message_option ? 0 : 1)) {
	    char *p;
	    p = rindex(path,'/');
	    lclfil = (p != NULL) ? p + 1 : path;
	}
	/* Otherwise local file is the second name */
	else lclfil = (message_option ? argv[0] : argv[1]);

 	vl = rd_vlink(path);
 
	if(!vl) {
	    if(perrno == PSUCCESS) fprintf(stderr,"vget: File not found\n");
	    else fprintf(stderr,"vget: %s\n",p_err_text[perrno]);
	    exit(1);
	}

 	am = pget_am(vl,am_args,P_AM_AFTP);
 
 	if(am == P_AM_AFTP) method = "AFTP";
	else {
 	    fprintf(stderr,"vget: Can't access file using anonymous ftp\n");
	    exit(1);
	}

	pid = fork();
	if (pid == 0) {
	    sprintf(vcachebin,"%s/vcache",P_BINARIES);
	    DISABLE_PFS(execl(vcachebin,"vcache",debugflag,verboseflag,
			      vl->host,vl->filename,lclfil,
			      method,am_args,0));
	    exit(1);
	}
	else wait(&status);

	if(status.w_T.w_Retcode) {
	    fprintf(stderr,"vget: Retrieve failed\n");
	    exit(1);
	}
	
	exit(0);

    }
