/*
 * Copyright (c) 1989, 1990, 1991 by the University of Washington
 *
 * For copying and distribution information, please see the file
 * <uw-copyright.h>.
 */

#include <uw-copyright.h>
#include <stdio.h>
#include <sys/param.h>
#include <sys/socket.h>

#include "ftp_var.h"

#include <pfs.h>

int		pfs_debug = 0;
int		cache_verbose = 0;

main(argc, argv)
    int	argc;
    char *argv[];
    {
	int	manage_cache = 0;
	int	replace = 0;
	int	flush = 0;
	int	retval = 0;

	char	*host;
	char	*remote;
	char	*local;
	char	*method;

	char	cachedir[MAXPATHLEN];
	char	*slash;

	debug = 0;
	verbose = 0;
	trace = 0;

	argc--;argv++;

	while (argc > 0 && *argv[0] == '-') {
	    switch (*(argv[0]+1)) {
		
	    case 'D':
		pfs_debug = 1; /* Default debug level */
		sscanf(argv[0],"-D%d",&pfs_debug);
		options |= SO_DEBUG;
		debug++;
		break;
			
	    case 'f':
		flush = 1;
		break;

	    case 'm':
		manage_cache = 1;
		break;

	    case 'r':
		replace = 1;
		break;
		
	    case 't':     /* FTP Trace */
		trace++;
		break;

	    case 'v':
		cache_verbose = 1;
		verbose = 1;
		break;

	    case NULL:
		break;

	    default:
		fprintf(stderr,
		      "Usage: vcache [-fmrv] host remote local method args\n");
		exit(1);
	    }
	    argc--; argv++;
	}
	if((argc == 1) && flush) {
	    host = NULL;
	    remote = NULL;
	    local = argv[0]; argc--; argv++;
	    method = NULL;
	}
	else if((argc == 0) && flush) {
	    host = NULL;
	    remote = NULL;
	    local = NULL;
	    method = NULL;
	}
	else if(argc >= 4) {
	    host = argv[0]; argc--; argv++;
	    remote = argv[0]; argc--; argv++;
	    local = argv[0]; argc--; argv++;
	    method = argv[0]; argc--; argv++;
	}
	else {
	    fprintf(stderr,
		    "Usage: vcache [-fmrv] host remote local method args\n");
	    exit(1);
	}

	/* Add code here to manage the cache */

	/* If no method provided, then we are done */
	if(!method) exit(0);

	/* Make the directory to include the chaced copy */
	/* if it does not already exist                  */
	strcpy(cachedir,local);
	slash = rindex(cachedir,'/');
	if(slash) {
	    *slash = '\0';
	    retval = mkdirs(cachedir);
	    if(retval && verbose) perror("Can't create local directory");
	    if(retval) exit(1);
	}

	if(strcmp(method,"AFTP") == 0) {
	    char	ftsuffix[MAX_PTXT_LEN];
	    char	trans_mode[MAX_PTXT_LEN];
	    if(argc != 1) {
		fprintf(stderr,"vcache: wrong number of arguments for AFTP\n");
		exit(1);
	    }
	    retval = sscanf(argv[0],"%s %s",ftsuffix,trans_mode);
	    if(retval != 2) {
		fprintf(stderr,"vcache: incorrect arguments for AFTP\n");
		exit(1);
	    }
	    if(strcmp(trans_mode,"DIRECTORY") == 0) {
		fprintf(stderr,"File is the directory %s on the host %s.\n",
			ftsuffix,host);
		fprintf(stderr,"%s may not be running Prospero.\n",host);
		exit(1);
	    }
	    retval = aftpget(host,local,ftsuffix,trans_mode);
	    if(retval) exit(1);
	    else exit(0);
	}
	else {
	   fprintf(stderr,"vcache: access method (%s) not supported\n",method);
	   exit(1);
	}
    }
