/*
 * Copyright (c) 1991 by the University of Washington
 *
 * For copying and distribution information, please see the file
 * <uw-copyright.h>.
 */

#include <uw-copyright.h>
#include <stdio.h>
#include <strings.h>

#include <pfs.h>
#include <perrno.h>
#include <pprot.h>
#include <pmachine.h>

int	perrno;
int	pfs_debug = 0;

extern	char	*acltypes[];

/*
 * Set ACL
 */
main(argc,argv)
    int		argc;
    char	*argv[];
    {
	char		*dname = "";        /* Directory name                */
	VLINK		dlink;
	int		retval;
	char		*lname = NULL;
	int		flags = 0;
	char		princstring[MAX_DIR_LINESIZE];
	int		incomp = 0;        /* Incompatible options */

	ACL_ST	a_st;
	ACL	a = &a_st;

	argc--;argv++;

	a->acetype = ACL_ASRTHOST;
	a->atype = "";
	a->rights = NULL;
	a->principals = NULL;

	while (argc > 0 && **argv == '-') {
	    switch (*(argv[0]+1)) {
		
	    case 'D':
		pfs_debug = 1; /* Default debug level */
		sscanf(argv[0],"-D%d",&pfs_debug);
		break;

	    case 'a': /* Add privs */
		if(incomp++) goto incomp_o;
		flags |= MACL_ADD;
		break;

	    case 'A': /* Next arg is authtype */
		a->atype = argv[1];
		argc--;argv++;
		break;

	    case 'd': /* Next arg is the directory name */
		dname = argv[1];
		argc--;argv++;
		break;

	    case 'E':  /* Entire create an entirely new ACL */
		if(incomp++) goto incomp_o;
		flags |= MACL_SET;
		break;

	    case 'i': /* Insert separate entry in ACL */
		if(incomp++) goto incomp_o;
		flags |= MACL_INSERT;
		break;

	    case 'K':  /* Kill ACL (reverts to DEFAULT or DIRECTORY) */
		if(incomp++) goto incomp_o;
		a->acetype = ACL_NONE;
		flags |= MACL_DEFAULT;
		break;

	    case 'l': /* Next arg is a link name */
		lname = argv[1];
		argc--;argv++;
		break;

	    case 'n': /* Do not include SYSTEM */
		flags |= MACL_NOSYSTEM;
		break;

	    case 'N': /* It's OK if I won't be able to change it again */
		flags |= MACL_NOSELF;
		break;

	    case 'r':  /* Remove individual ACL entry */
		if(incomp++) goto incomp_o;
		flags |= MACL_DELETE;
		break;

	    case 's': /* Subtract privs */
		if(incomp++) goto incomp_o;
		flags |= MACL_SUBTRACT;
		break;

	    case 't': /* Next arg is the type of ACL entry */
		for(a->acetype = 0;acltypes[a->acetype];(a->acetype)++) {
		    if(strccmp(acltypes[a->acetype],argv[1])==0)
			break;
		}
		if(acltypes[a->acetype] == NULL) {
		    fprintf(stderr,"set_acl: Unknown ACL type\n");
		    exit(1);
		}		    
		argc--;argv++;
		break;

	    incomp_o:
		fprintf(stderr,"set_acl: Incompatible options specified\n");
	    default:
		fprintf(stderr,"Usage: set_acl [-asirKE,-n,-N] [-t type] [-d dir] [-l link] rights principals\n");
		exit(1);
	    }
	    argc--, argv++;
	}

	if(!incomp) flags |= MACL_ADD;

	if(((argc < 1) && ((a->acetype == ACL_OWNER)||
			   (a->acetype == ACL_ANY)))||
	   ((argc < 2) && ((a->acetype == ACL_AUTHENT)||
			   (a->acetype == ACL_LGROUP)||
			   (a->acetype == ACL_GROUP)||
			   (a->acetype == ACL_ASRTHOST)||
			   (a->acetype == ACL_TRSTHOST)))) {
	    fprintf(stderr,"Usage: set_acl [-asirKE,-n,-N] [-t type] [-d dir] [-l link] rights principals\n");
	    exit(1);
	}

	if(argc >= 1) a->rights = argv[0];
	argc--;argv++;

	*princstring = '\0';
	while(argc > 0) {
	    strcat(princstring," ");
	    strcat(princstring,argv[0]);
	    argc--;argv++;
	}
	if(strlen(princstring) > 1) a->principals = princstring+1;

	perrno = 0;
	dlink = rd_vlink(dname);
	if(!dlink) {
	    fprintf(stderr, "set_acl: Couldn't find %s\n",dname);
	    exit(1);
	}

	if(lname) flags |= MACL_LINK;
	else flags |= MACL_DIRECTORY;

	retval = modify_acl(dlink,lname,a,flags);

	if(retval) {
	    fprintf(stderr,"set_acl failed: %s\n",p_err_text[retval]);
	    exit(1);
	}


	exit(0);
    }

