/*
 * Copyright (c) 1989, 1990 by the University of Washington
 *
 * For copying and distribution information, please see the file
 * <uw-copyright.h>.
 */

#include <uw-copyright.h>
#include <stdio.h>

#include <pfs.h>
#include <perrno.h>
#include <pprot.h>

extern int	perrno;
int		pfs_debug = 0;

main(argc,argv)
    int		argc;
    char	*argv[];
    {
        PTEXT		request;
	PTEXT		resp;

	char		dirhst[40];
	char		*command = "STATUS";

	argc--;argv++;

	while (argc > 0 && **argv == '-') {

	    switch (*(argv[0]+1)) {
		
	    case 'D':
		pfs_debug = 1; /* Default debug level */
		sscanf(argv[0],"-D%d",&pfs_debug);
		break;

	    case 'v':
		command = "VERSION";
		break;
		
	    default:
		fprintf(stderr,
			"Usage: pstatus [-v] [host name]\n");
		exit(1);
	    }
	    argc--, argv++;
	}

	request = ptalloc();

	gethostname(dirhst,40);

	if(argc > 1) {
	    fprintf(stderr,"Usage: pstatus [host name]\n");
	    exit(1);
	}

	if(argc > 0)
	    strcpy(dirhst,argv[0]);

	sprintf(request->start,"%s\n",command);

	request->length = strlen(request->start);

	printf("Sending message to %s...\n%",dirhst);
	
	resp = dirsend(request,dirhst,0);

	if(resp == NULL) {
	    printf("pstatus failed: %s\n",p_err_text[perrno]);
	    exit(1);
	}

	while(resp->next) resp = resp->next;

	printf("Response:\n%s",resp->start);

	if(*(resp->start+strlen(resp->start)-1) != '\n') 
	    printf("\n");

	ptlfree(request);
	ptlfree(resp);
	exit(0);

    }

