/*
 * Copyright (c) 1991 by the University of Washington
 *
 * For copying and distribution information, please see the file
 * <uw-copyright.h>.
 */

#include <uw-copyright.h>
#include <stdio.h>

#include <pfs.h>
#include <perrno.h>

#define ARCHIE_HOST "QUICHE.CS.MCGILL.CA"


char	*index();

int	perrno;
int	pfs_debug = 0;

main(argc,argv)
    int		argc;
    char	*argv[];
    {
	VDIR_ST		dir_st;
	VDIR		dir= &dir_st;
	VLINK		l;
	VLINK		crep;
	int		verbose = 0;
	int		dmagic = 0;
	int		show_failed = 0;
	int		replica_flag = 0;
	int		conflict_flag = 0;
	int		tmp;
	char		*progname = argv[0];
	int		max_hits = 100;
	/* Default to exact string match, it's faster */
	char		qtype = '=';
	char		*host = ARCHIE_HOST;
	char		dfile[200];

	VLINK		matchlist;
	VLINK		tlp;    /* Temporay link pointer */
	VLINK		slinks; /* Sorted links          */

	vdir_init(dir);

	argc--;argv++;

	verbose = 1;
	conflict_flag++;

	while (argc > 0 && **argv == '-') {
	    switch (*(argv[0]+1)) {
		
	    case 'D':  /* Debug level */
		pfs_debug = 1; /* Default debug level */
		sscanf(argv[0],"-D%d",&pfs_debug);
		break;

	    case 'h':  /* Host */
		if(argc == 1) {
		    /* No host specified, consider it a request for help */
		    fprintf(stderr,"Usage: prog [-c,-C,-e,-r,-m count,-h host] search-string\n");
		    fprintf(stderr,"       -c : case insensitive substring search\n");
		    fprintf(stderr,"       -C : case sensitive substring search\n");
		    fprintf(stderr,"       -e : exact string match (default)\n");
		    fprintf(stderr,"       -r : regular expression search\n");
		    fprintf(stderr,"     -m # : specifies maximum number of hits to return\n");
		    fprintf(stderr,"  -h host : specifies server host\n");
		    exit(1);
		}
		host = argv[1];
		argc--;argv++;
		break;

	    case 'm':  /* Max hits */
		tmp = sscanf(argv[1],"%d",&max_hits);
		argc--;argv++;
		break;

	    case 'r':  /* Max hits */
		qtype = 'R';
		break;

	    case 'e':  /* Max hits */
		qtype = '=';
		break;

	    case 'c':  /* Max hits */
		qtype = 'c';
		break;

	    case 'C':  /* Max hits */
		qtype = 'C';
		break;

	    default:
		fprintf(stderr,
			"Usage: prog [-c,-C,-e,-r,-m count,-h host] search-string\n");
		exit(1);
	    }
	    argc--, argv++;
	}

	if (argc != 1) {
	    fprintf(stderr,"Usage: prog [-c,-C,-e,-r,-m count,-h host] search-string\n");
	    fprintf(stderr,"       -c : case insensitive substring search\n");
	    fprintf(stderr,"       -C : case sensitive substring search\n");
	    fprintf(stderr,"       -e : exact string match (default)\n");
	    fprintf(stderr,"       -r : regular expression search\n");
	    fprintf(stderr,"     -m # : specifies maximum number of hits to return\n");
	    fprintf(stderr,"  -h host : specifies server host\n");
	    exit(1);
	}

	sprintf(dfile,"ARCHIE/MATCH(%d,0,%c)/%s",max_hits,qtype,argv[0]);

	tmp = get_vdir(host,dfile,"",dir,GVD_ATTRIB,NULL,NULL);

	if(tmp) {
	    fprintf(stderr,"%s failed: %s\n",progname,p_err_text[tmp]);
	    exit(1);
	}

	l = dir->links;

	matchlist = NULL;

	/* Insert links in list sorted by host then filename */
	while(l) {
	    crep = l;
	    l = l->next;
	    while(crep) {
		tlp = crep;
		if(crep->next == l) crep = crep->replicas;
		else crep = crep->next;

		sort_ins_link(&matchlist,tlp);
	    }
	}


	l = matchlist;
	while(l) {
	    display_link(l);
	    l = l->next;
	}

	vllfree(l);
	printf("\n");
	exit(0);

    }


display_link(l)
    VLINK	l;
    {
	PATTRIB 	ap;
	char		linkpath[MAX_VPATH];
	static char	lastpath[MAX_VPATH] = "\001";
	static char	lasthost[MAX_VPATH] = "\001";
	int		dirflag = 0;
	int		size = 0;
	char		*modes = "";
	char		*archie_date = "";

	if(sindex(l->type,"DIRECTORY")) dirflag = 1;
	else dirflag = 0;

	strcpy(linkpath,l->filename);
	*(linkpath + (strlen(linkpath) - strlen(l->name) - 1)) = '\0';

	if(strcmp(l->host,lasthost)) {
	    printf("\nHost %s\n\n",l->host);
	    strcpy(lasthost,l->host);
	    *lastpath = '\001';
	}
	    
	if(strcmp(linkpath,lastpath)) {
	    if(*linkpath)  printf("    Location: %s\n",linkpath);
	    else printf("    Location: /\n");
	    strcpy(lastpath,linkpath);
	}

	ap = l->lattrib;
	while(ap) {
	    if(strcmp(ap->aname,"SIZE") == 0) {
		sscanf(ap->value.ascii,"%d",&size);
	    }
	    else if(strcmp(ap->aname,"UNIX-MODES") == 0) {
		modes = ap->value.ascii;
	    }
	    else if(strcmp(ap->aname,"ARC-MODTIME") == 0) {
		archie_date = ap->value.ascii;
	    }
	    ap = ap->next;
	}

	printf("      %s %s %10d  %s  %s\n",
	       (dirflag ? "DIRECTORY" : "FILE     "), 
	       modes,size,archie_date,l->name);
	
	atlfree(l->lattrib); l->lattrib = NULL;
	return(PSUCCESS);
    }



sort_ins_link(listp,l)
    VLINK	*listp;		/* Pointer to list that gets link       */
    VLINK	l;		/* Link to be inserted                  */
    {
	VLINK	tl;		/* Temporary link pointer               */
	char	*slash;		/* For finding the slash in pseudo dirs */

	/* If the link is for an archie-pseudo directory, fix it */
	if(strcmp(l->type,"DIRECTORY")==0) {
	    if(strncmp(l->filename,"ARCHIE/HOST",11)== 0) {
		l->host = stcopyr(l->filename+12,l->host);
		slash = index(l->host,'/');
		if(slash) {
		    l->filename = stcopyr(slash,l->filename);
		    *slash++ = '\0';
		}
		else l->filename = stcopyr("",l->filename);
	    }
	}

	/* Clear the replica pointer */
	l->replicas = NULL;

	tl = *listp;
	while(tl) {
	    /* if tl host name is smaller, continue */
	    if(strcmp(tl->host,l->host) < 0) {
		tl = tl->next;
		continue;
	    }
	    /* If same host, but file name is smaller, continue */
	    if((strcmp(tl->host,l->host) == 0) &&
	       (strcmp(tl->filename,l->filename) < 0)) {
		tl = tl->next;
		continue;
	    }
	    /* Insert link before tl */
	    if(tl == *listp) {
		l->next = tl;
		l->previous = NULL;
		tl->previous = l;
		*listp = l;
		return(PSUCCESS);		
	    }
	    else {
		l->next = tl;
		l->previous = tl->previous;
		tl->previous->next = l;
		tl->previous = l;
		return(PSUCCESS);
	    }
	}
	/* Insert at end */
	tl = *listp;
	while(tl && tl->next) tl = tl->next;
	if(tl) {
	    tl->next = l;
	    l->next = NULL;
	    l->previous = tl;
	}
	else {
	    *listp = l;
	    l->next = NULL;
	    l->previous = NULL;
	}
	return(PSUCCESS);
    }
