/*
 * Copyright (c) 1991 by the University of Washington
 *
 * For copying and distribution information, please see the file
 * <uw-copyright.h>.
 */

#include <uw-copyright.h>
#include <stdio.h>
#include <strings.h>

#include <pfs.h>
#include <perrno.h>
#include <pmachine.h>

int	perrno;
int	pfs_debug = 0;

extern	char	*acltypes[];

/*
 * List ACL
 */
main(argc,argv)
    int		argc;
    char	*argv[];
    {
	char		*dname = "";        /* Directory name                */
	char		*lname = NULL;
	VLINK		dlink;
	ACL		a;

	argc--;argv++;

	while (argc > 0 && **argv == '-') {
	    switch (*(argv[0]+1)) {
		
	    case 'D':
		pfs_debug = 1; /* Default debug level */
		sscanf(argv[0],"-D%d",&pfs_debug);
		break;

	    case 'd':
		dname = argv[1];
		argc--;argv++;
		break;

		/* This is but it makes it consistent with set_acl */
	    case 'l': /* Next arg is a link name */
		lname = argv[1];
		argc--;argv++;
		break;

	    default:
		fprintf(stderr, "Usage: list_acl [-d dir] [link-name]\n");
		exit(1);
	    }
	    argc--, argv++;
	}

	if(argc > (lname ? 0 : 1)) {
	    fprintf(stderr, "Usage: list_acl [-d dir] [link-name]\n");
	    exit(1);
	}

	if(argc == 1) lname = argv[0];

	dlink = rd_vlink(dname);
	if(!dlink) {
	    fprintf(stderr, "list_acl: Failed to read directory link\n");
	    exit(1);
	}

	if(lname) a = get_acl(dlink,lname,1);
	else a = get_acl(dlink,NULL,0);

	if(!a && perrno) {
	    fprintf(stderr,"list_acl failed: %s\n",p_err_text[perrno]);
	    exit(1);
	}

	printf("Access Control list for %s%s%s\n\n", (*dname ? dname : "."), 
	       (lname ? " -> " : ""), (lname ? lname : ""));

	while(a) {
	    char	typestring[40];
	    char	*rightst = "";
	    char	*princst = "";

	    if(a->rights) rightst = a->rights;
	    if(a->principals) princst = a->principals;

	    if(a->atype && *(a->atype))
		sprintf(typestring,"%s(%s)",acltypes[a->acetype],a->atype); 
	    else strcpy(typestring,acltypes[a->acetype]);

	    printf("  %-26s %-16s %s\n",typestring,rightst,princst);

	    a = a->next;
	}
	    
	printf("\n");

	exit(0);
    }

