/*
 * Copyright (c) 1989, 1990, 1991 by the University of Washington
 *
 * For copying and distribution information, please see the file
 * <uw-copyright.h>.
 */

#include <uw-copyright.h>

#include <stdio.h>
#include <sys/param.h> 
#include <pwd.h> 

#include <psite.h>
#include <pmachine.h>

#ifdef PSRV_ROOT
static char    root[40]      = PSRV_ROOT;
#else
static	char    root[40]      = "";
#endif

#ifdef AFTPDIRECTORY
static	char	aftpdir[40]   = AFTPDIRECTORY;
#else
static	char	aftpdir[40]   = "";
#endif

#ifdef AFSDIRECTORY
static	char	afsdir[40]    = AFSDIRECTORY;
#else
static	char	afsdir[40]    = "";
#endif

main(argc,argv)
    int		argc;
    char	*argv[];
    {
	char		pfsdir[MAXPATHLEN];
	char		pfsdat[MAXPATHLEN];
	char		pfshadow[MAXPATHLEN];
	char		dirsrv_b[MAXPATHLEN];


	struct passwd   *pw;

	int		ruid,euid;

	if (argc > 2) {
	    fprintf(stderr,"Usage: %s [full-host-name]\n",argv[0]);
	    exit(1);
	}

#ifdef AFTPUSER
	/* Find FTP directory - if error, use AFTPDIRECTORY */
	if((pw = getpwnam(AFTPUSER)) != NULL) {
	/*  if(chdir(pw->pw_dir) == 0) */
	/*	getwd(aftpdir);        */
	    strcpy(aftpdir,pw->pw_dir);
	}
#endif AFTPUSER

	/* Find the shadow and data directories */
	if((pw = getpwnam(P_USER_ID)) == NULL) {
	    fprintf(stderr,"%s: Can't find passwd entry for %s.\n",
		    argv[0],P_USER_ID);
	    exit(1);
	}

	if(chdir(pw->pw_dir)) {
	    fprintf(stderr,"%s: Can't change working directory.\n",argv[0]);
	    exit(1);
	}

#ifdef P_UNDER_UDIR
	/* getwd(pfsdir); */
	strcpy(pfsdir,pw->pw_dir);

	sprintf(pfsdat,"%s/%s",pfsdir,P_STORAGE);
	sprintf(pfshadow,"%s/%s",pfsdir,P_SHADOW);
#else
	strcpy(pfsdat,P_FSTORAGE);
	strcpy(pfshadow,P_FSHADOW);
#endif P_UNDER_UDIR

	sprintf(dirsrv_b,"%s/dirsrv",P_BINARIES);

	umask(0);

	ruid = getuid();
	euid = geteuid();

  	if((ruid != pw->pw_uid) || (euid != pw->pw_uid)) {
	    if(setuid(pw->pw_uid)) {
		fprintf(stderr,"%s: Can't set uid.\n",argv[0]);
		exit(1);
	    }

	    if(setgid(pw->pw_gid)) {
  		fprintf(stderr,"%s: Can't set gid.\n",argv[0]);
  		exit(1);
  	    }
	}

	if (argc > 1) 
	    execl(dirsrv_b,"dirsrv",root,pfshadow,pfsdat,
		  aftpdir,afsdir,argv[1],(char *) 0);
	else 
	    execl(dirsrv_b,"dirsrv",root,pfshadow,pfsdat,
		  aftpdir,afsdir,(char *) 0);
	
	/* Execl failed */
	exit(1);
    }
