/*
 * Copyright (c) 1989, 1990 by the University of Washington
 *
 * For copying and distribution information, please see the file
 * <uw-copyright.h>.
 */

#include <uw-copyright.h>
#include <stdio.h>
#include <netdb.h>
#include <signal.h>
#include <sgtty.h>
#include <sys/ioctl.h>
#include <sys/time.h>
#include <sys/file.h>

#include <plog.h>
#include <pfs.h>
#include <pprot.h>
#include <perrno.h>

extern int	f;

/*
 * reply - reply takes an address to which a reply is to be sent, and
 * a response to be sent.  It then adds the response to a buffer and
 * sends the bufered responses if the buffer length approaches the maximum
 * packet size.  reply keeps track of the packet number and tags
 * outgoing packets if necessary or a multi packet response.
 */
reply(req,message)
    PREQ		req;
    char		*message;
    {
	int		last_seq = 0;
	if(!req->cpkt) req->cpkt = ptalloc();

	/* Here we need to check lengths and add message number if necessary */
	if((strlen(message) + req->cpkt->length + SEQ_SIZE) > MAXPKT) {
	    if(!req->cpkt->seq) req->cpkt->seq = 1;
	    last_seq = req->cpkt->seq;
	    transmit(req);
	    req->cpkt = ptalloc();
	    req->cpkt->seq = last_seq + 1;
	}

	strcpy(req->cpkt->start + req->cpkt->length,message);
	req->cpkt->length += strlen(message);
	return(PSUCCESS);
    }

/*VARARGS2*/

/*
 * replyf - replyf performs the same function as reply except that the
 * message to be sent is provided in the same form as for printf.  A
 * <CR> will be added at the end of the message.
 */

replyf(req,format,a1,a2,a3,a4,a5,a6,a7,a8,a9,a10,a11,a12,a13,a14,a15)
    PREQ		req;
    char 		*format;
    char		*a1,*a2,*a3,*a4,*a5,*a6,*a7,*a8;
    char		*a9,*a10,*a11,*a12,*a13,*a14,*a15;
    {
	char 	buf[MAX_DIR_LINESIZE];

	sprintf(buf,format,a1,a2,a3,a4,a5,a6,a7,a8,a9,a10,a11,a12,a13,a14,a15);
	strcat(buf,"\n");

	/* Perform the reply and pass through any error codes */
	return(reply(req,buf));
    }


/*
 * sendm - sendm takes an address to which a reply is to
 * be sent and forces any queued messages to actually be sent.  This is
 * used at the end of any multiple message response.  sendm also
 * takes an optional message to be sent, thus allowing a single messages
 * to be specified and sent in a single call.
 *
 * If sendm is called and no messages are queued or specified, an
 * error will be returned.
 */
sendm(req,message)
    PREQ		req;
    char		*message;
    {
	/* Add the message to those already queued */
	if(message && *message) reply(req,message);

	/* Return an error if there is no response waiting */
	/* by this point                                   */
	if(!req->cpkt) return(PFAILURE);

	/* Send the queued messages and pass through any error code */
	req->cpkt->seq *= -1;
	return(transmit(req));
    }

/*VARARGS2*/

/*
 * sendmf - sendmf performs the same function as sendm, but the optional
 * message to be sent is specified in the same manner as for a printf.
 * A <CR> will be added at the end of the message.
 */
sendmf(req,format,a1,a2,a3,a4,a5,a6,a7,a8,a9,a10,a11,a12,a13,a14,a15)
    PREQ		req;
    char 		*format;
    char		*a1,*a2,*a3,*a4,*a5,*a6,*a7,*a8;
    char		*a9,*a10,*a11,*a12,*a13,*a14,*a15;
    {
	char 	buf[MAX_DIR_LINESIZE];

	sprintf(buf,format,a1,a2,a3,a4,a5,a6,a7,a8,a9,a10,a11,a12,a13,a14,a15);
	strcat(buf,"\n");

	/* Send the message and pass through any error codes */
	return(sendm(req,buf));
    }


#ifdef NOTDEF
/*
 * transmit - transmit takes an address to which a reply is to
 * be sent and forces any queued messages to actually be sent.  
 * If the packet sequnce number is non-zero, then a line of the
 * form MULTI-PACKET XX is added.  If it is negative, then this
 * is assumed to be the last packet, and an OF XX is also added.
 */
static
transmit(recipient)
    struct sockaddr_in	*recipient;
    {
	char 	buf[MAX_DIR_LINESIZE];
	int	sent;
	short	zero = 0;
	short	nseq = 0;
	short	ntotal = 0;

	*buf = '\0';

	if(!req->cpkt) return(PFAILURE);

        if(req->cpkt->seq > 0) {
	    sprintf(buf,"MULTI-PACKET %d\n",req->cpkt->seq);
	    nseq = htons((u_short) req->cpkt->seq);
	}
	else if(req->cpkt->seq < 0) {
	    sprintf(buf, "MULTI-PACKET %d OF %d",
		    -req->cpkt->seq, -req->cpkt->seq);
	    nseq = htons((u_short) -req->cpkt->seq);
	    ntotal = htons((u_short) -req->cpkt->seq);
	}
	else {
	    nseq = htons((u_short) 1);
	    ntotal = htons((u_short) 1);
	}

#ifdef REALLYNEW
	/* Note that in the following, we don't have to make sure  */
	/* there is room for the header in the packet because we   */
	/* are the only one that moves back the start, and ptalloc */
	/* allocates space for us in all packets it creates        */

	/* If a single message and no connection ID to return, */
	/* then we can leave the control fields out            */
	if(req->cpkt->seq == 0) {
	    req->cpkt->start -= 1;
	    req->cpkt->length += 1;
	    *req->cpkt->start = (char) 1;
	}
	else {	    /* Fill in the control fields */
	    req->cpkt->start -= 7;
	    req->cpkt->length += 7;
	    *req->cpkt->start = (char) 7;

	    bcopy(&zero,req->cpkt->start+1,2);     /* Conn ID */
	    bcopy(&nseq,req->cpkt->start+3,2);   /* Pkt no  */
	    bcopy(&ntotal,req->cpkt->start+5,2); /* Total   */
	}
	/* Make room for the trailing null */
	req->cpkt->length += 1;

#else /* Not really new */
#ifndef DONTSUPPORTOLD
	/* Copy the buffer and update length (count the trailing null) */
	strcat(req->cpkt->start + req->cpkt->length, buf);
	req->cpkt->length += strlen(buf) + 1;
#else
	/* Make room for the trailing null */
	req->cpkt->length += 1;
#endif

	/* If a single message and no connection ID to return, */
	/* then we can leave the control fields out            */
	if(req->cpkt->seq != 0) {
	    /* Fill in the control fields */
	    bcopy(&zero,req->cpkt->start+req->cpkt->length,2);     /* Conn ID */
	    bcopy(&nseq,req->cpkt->start+req->cpkt->length+2,2);   /* Pkt no  */
	    bcopy(&ntotal,req->cpkt->start+req->cpkt->length+4,2); /* Total   */

	    req->cpkt->length += 6;
	}
#endif

        sent = sendto(f, req->cpkt->start, req->cpkt->length, 
		      0, recipient, S_AD_SZ);

	if(sent != req->cpkt->length) return(REPLY_NOTSENT);

	ptfree(req->cpkt);
	req->cpkt = NULL;
        return(PSUCCESS);
    }

#endif
