/*
 * Copyright (c) 1989, 1990 by the University of Washington
 *
 * For copying and distribution information, please see the file
 * <uw-copyright.h>.
 */

#include <uw-copyright.h>
#include <sys/time.h>
#include <stdio.h>

#include <psite.h>
#include <pfs.h>
#include <plog.h>
#include <pmachine.h>
    
/* this array contains info on the type of entries to be printed */
static int 		logtype_array[NLOGTYPE] = INITIAL_LOG_VECTOR;

/* info on the filename and open file */
static char 		*log_name = PFS_LOGFILE;
FILE 			*logfile;
static int 		is_open;

static char 		logtxt[MXVLOGENTRY];

static char *pr_inet_ntoa();

/*VARARGS4*/

/*
 * plog - Add entry to logfile
 *
 * 	  PLOG is used to add entries to the logfile.  Note that
 * 	  it is probably not portable since is makes assumptions
 * 	  about what the compiler will do when it is called with
 * 	  less than the correct number of arguments which is the
 * 	  way it is usually called.
 *
 * 	  PLOG returns a pointer to the logged entry.  If an error
 * 	  occurs, vlog returns immediately, but does not indicate 
 * 	  that the log operating failed.
 *
 *    ARGS: type    - Type of entry (to decide if we should log it)
 *	    address - host address (0 if should not be printed)
 *	    userid  - User ID from authenticator (0 if should not be printed)
 *          format  - Format as for printf
 *          a1-a0   - Args.  Must terminate with a 0.
 * RETURNS: Pointer to a string containing the log entry
 *
 *    BUGS: This is not portable.  It should really use another
 *          mechanism to support a variable number of arguments.
 *
 *          Currently, the log file is opened and closed on each
 *	    call.
 */
char *
plog(type,address,userid,format,a1,a2,a3,a4,a5,a6,a7,a8,a9,a0)
    int		type;		/* Type of log entry	 */
    long	address;	/* Optional host address */
    char	*userid;	/* Optional user ID      */
    char	*format;	/* Format String	 */
    int		a1,a2,a3,a4,a5,a6,a7,a8,a9,a0; /* Args   */
{
    long time(),now;
    struct tm *tm;
    char *month_sname();

    (void) sprintf(logtxt,format,a1,a2,a3,a4,a5,a6,a7,a8,a9,a0);

    /* If we don't log this type of message, don't write to log */
    if (!logtype_array[type])
	return(logtxt);

    if (!is_open) {
	if ((logfile = fopen(log_name,"a")) == NULL)
	    return(logtxt);
	is_open = 1;
    }

    /* get the time */
    (void) time(&now);
    tm = localtime(&now);

    /* print the log entry */
    fprintf(logfile,"%2d-%s-%02d %02d:%02d:%02d ",tm->tm_mday,
            month_sname(tm->tm_mon + 1),tm->tm_year,
            tm->tm_hour, tm->tm_min, tm->tm_sec);
    if(address) fprintf(logfile,"%s",pr_inet_ntoa(address));
    if(userid && *userid && logtype_array[L_USER_IDS]) 
	fprintf(logfile,"(%s)",userid);
    fprintf(logfile," - %s\n",logtxt);

    (void) fclose(logfile);
    is_open = 0;

    return(logtxt);
}

/*
 * vset_logfile - Change the name of the logfile
 *
 *		  VSET_LOGFILE changes the name of the file to which
 * 		  messages are logged.  If set_logfile is not called,
 * 		  the logfile defaults to PFSLOG.
 *
 *         ARGS:  filename - Name of new logfile
 *      Returns:  success always
 */
set_logfile(filename)
    char *filename;
{
    log_name = filename;
    if(is_open) (void) fclose(logfile);
    is_open = 0;
    return(PSUCCESS);
}

static char *pr_inet_ntoa(a)
    long a;
    {
	static char	astring[20];

#if BYTE_ORDER == BIG_ENDIAN
	sprintf(astring,"%d.%d.%d.%d",(a >> 24) & 0xff,
		(a >> 16) & 0xff,(a >> 8) & 0xff, a & 0xff);
#else
	sprintf(astring,"%d.%d.%d.%d", a & 0xff,
		(a >> 8) & 0xff,(a >> 16) & 0xff, (a >> 24) & 0xff);
#endif
	
	return(astring);
    }
		
