/*
 * Copyright (c) 1991 by the University of Washington
 *
 * For copying and distribution information, please see the file
 * <uw-copyright.h>.
 */

#include <uw-copyright.h>


#include <netdb.h>
#include <sgtty.h>
#include <signal.h>
#include <setjmp.h>
#include <stdio.h>
#include <strings.h>
#include <sys/time.h>
#include <sys/file.h>
#include <sys/ioctl.h>
#include <sys/param.h>
#include <sys/socket.h>

#include <pfs.h>
#include <psite.h>
#include <plog.h>
#include <pauthent.h>
#include <pprot.h>
#include <perrno.h>
#include <pmachine.h>

static	PREQ	pending = NULL;
static	PREQ	incomplete = NULL;
static  PREQ	accepted = NULL;

extern int	errno;

static int		srvport = 0;
static fd_set		readfds = 0;	/* Used for select		 */
static struct timeval	zerotime; 

bind_port(sinp)
    struct sockaddr_in *sinp;
    {
	int     		on = 1;

	zerotime.tv_sec = 0;
	zerotime.tv_usec = 0;

	if ((srvport = socket(AF_INET, SOCK_DGRAM, 0)) < 0) {
	    plog(L_STATUS,NULL,NULL,"Can't open socket",0);
	    fprintf(stderr, "dirsrv: Can't open socket\n");
	    exit(1);
	}
	if (setsockopt(srvport, SOL_SOCKET, SO_REUSEADDR, &on, sizeof(on)) < 0)
	    fprintf(stderr, "dirsrv: setsockopt (SO_REUSEADDR)\n");
	
	if (bind(srvport, sinp, S_AD_SZ) < 0) {
	    plog(L_STATUS,NULL,NULL,"Can't bind socket",0);
	    fprintf(stderr, "dirsrv: Can not bind socket\n");
	    exit(1);
	}
	return(PSUCCESS);
    }


check_for_messages()
    {
	struct sockaddr_in 	from;
	int			fromlen;
	int			n = 0;
	PTEXT			pkt;
	int			cid = 0;
	int			pkt_no = 0;
	int			tot_pkt = 0;
	int			recvd_thru = 0;
	int			tmp;
	PREQ		      	treq; /* Temporary request pointer */
	PREQ			nreq; /* New request pointer       */
	int			reqcnt = 0;
	int			hdr_len;
	char			*ctlptr;
	short			stmp;

    check_for_more:

	FD_ZERO(&readfds);
	FD_SET(srvport, &readfds);
	tmp = select(srvport + 1,&readfds,(fd_set *)0,(fd_set *)0,&zerotime);

	if(tmp == 0) return(PSUCCESS);
	if(tmp < 0) return(PFAILURE);

	pkt = ptalloc();

	/* There is a message waiting, add it to the queue */

	fromlen = sizeof(from);
	n = recvfrom(srvport, pkt->dat, MAX_PTXT_LEN, 0, &from, &fromlen);
	if (n <= 0) {
	    plog(L_NET_ERR,NULL,NULL,"Bad recvfrom n = %d errno = %d",n,errno,0);
	    return(PFAILURE);
	}

	pkt->start = pkt->dat;
	pkt->length = n;
	*(pkt->start + pkt->length) = NULL;
	pkt->mbz = 0; /* force zeros to catch runaway strings     */

	pkt->seq = 1;
	if((hdr_len = (unsigned char) *(pkt->start)) < 20) {
	    ctlptr = pkt->start + 1;
	    pkt->seq = 0;
	    if(hdr_len >= 3) { 	/* Connection ID */
		bcopy(ctlptr,&stmp,2);
		if(stmp) cid = ntohs(stmp);
		ctlptr += 2;
	    }
	    if(hdr_len >= 5) {	/* Packet number */
		bcopy(ctlptr,&stmp,2);
		pkt->seq = ntohs(stmp);
		ctlptr += 2;
	    }
	    else { /* No packet number specified, so this is the only one */
		pkt->seq = 1;
		tot_pkt = 1;
	    }
	    if(hdr_len >= 7) {	    /* Total number of packets */
		bcopy(ctlptr,&stmp,2);  /* 0 means don't know      */
		if(stmp) tot_pkt = ntohs(stmp);
		ctlptr += 2;
	    }
	    if(hdr_len >= 9) {	/* Receievd through */
		bcopy(ctlptr,&stmp,2);  /* 0 means don't know      */
		if(stmp) recvd_thru = ntohs(stmp);
		ctlptr += 2;
	    }
	    if(hdr_len >= 11) {	/* Backoff */
		/* Not supported by server */
	    }
	    ctlptr += 2;
	}
	else {
	    pkt->seq = 1;
	    tot_pkt = 1;
	}
	if(pkt->seq == 0) goto check_for_more;
	if(hdr_len < 20) {
	    pkt->length -= hdr_len;
	    pkt->start += hdr_len;
	}

	/* Check to see if it is already on incomplete, pending, or accepted */

	/* For now let's assume not - this code will be come important */
	/* when the client code is change to include connectiopn IDs   */

	plog(L_NET_INFO, from.sin_addr, NULL, "Received packet", 0);

	/* If this message is complete, insert it at end of pending */
	if((pkt->seq == 1) && (tot_pkt == 1)) {
	    nreq = pralloc();
	    treq = pending;

	    nreq->cid = cid;
	    nreq->recv_tot = 1;
	    nreq->recv = pkt;
	    bcopy(&from,&(nreq->fromto),sizeof(nreq->fromto));

	    if(pending) {
		while(treq) {
		    reqcnt++;
		    if(!treq->next) {
			treq->next = nreq;
			nreq->previous = treq;
			break;
		    }
		    treq = treq->next;
		}
	    }
	    else pending = nreq;

	    if(++reqcnt > 4) 
		plog(L_QUEUE_INFO,NULL,NULL,"Queue length: %d",reqcnt,0);

	    /* Here we can optionally send a message telling the  */
	    /* client to back off.  How long should depend on the */
	    /* queue length and the mean service time             */
	    /* 15 min for now - the archie server is overloaded   */
	    transmit_wait(nreq,900); 
	}
	/* Otherwise add it to incomplete */
	else {
	    /* Note that at this point, no clients generate multi- */
	    /* packet requests.                                    */
	    plog(L_NET_ERR,NULL,NULL,"Multi-packet request received - ignored",0);
	    goto check_for_more;
	}
	
	goto check_for_more;
    }

PREQ get_next_request()
    {
	PREQ	nextreq;
	int	tmp;

    tryagain:
	check_for_messages();
	/* return next message in queue */
	if(pending) {
	    nextreq = pending;
	    pending = nextreq->next;
	    nextreq->next = NULL;
	    return(nextreq);
	}

	/* if queue is empty, then wait till somethings comes */
	/* in, then go back to start                          */
	FD_ZERO(&readfds);
	FD_SET(srvport, &readfds);
	tmp = select(srvport + 1, &readfds, (fd_set *)0, (fd_set *)0, NULL);
	goto tryagain;
    }


/*
 * transmit_wait - sends a message to the recipient indicating that
 * there may be a delay before the request can be processed.
 * The recipient should backoff and not attempt any retries
 * until the time in the message has elapsed.
 */
transmit_wait(req,timetowait)
    PREQ		req;
    int			timetowait;
    {
        PTEXT		r = ptalloc();
        int		sent;
	int		thisseq;
	short		nseq = 0;
	short		zero = 0;
	short		backoff;

	/* Note that control information follows the null  */
	/* that terminates the text.  Since no text is     */
	/* being sent in this message, we must add a null  */
	/* at the start.                                   */
	     
#ifndef DONTSUPPORTOLD
	/* For now we have to give this message a positive   */
	/* sequence number.  Once all clients have the new   */
	/* code, we will be able to assign a sequence number */
	/* of zero indicating that it is not to be returned  */
	/* to the application                                */
	if(req->cpkt) {
	    thisseq = (req->cpkt->seq)++;
	    nseq = htons((u_short) thisseq);
	}
	else {
	    thisseq = 1;
	    nseq = htons((u_short) thisseq);
	    req->cpkt = ptalloc();
	    req->cpkt->seq = 2;
	}
	/* We also have to include an old style command line */
	/* Eventually we can replace with a single null byte */
	sprintf(r->start,"MULTI-PACKET %d\n",thisseq);
	r->length = strlen(r->start) + 1;
#else
	*r->start = (char) 11;
	r->length = 1;
#endif

	backoff = htons((u_short) timetowait);

	bcopy(&zero,r->start+r->length,2);  	/* Connection ID     */
	bcopy(&nseq,r->start+r->length+2,2);	/* Packet number     */
	bcopy(&zero,r->start+r->length+4,2);	/* Total packets     */
	bcopy(&zero,r->start+r->length+6,2);	/* Received through  */
	bcopy(&backoff,r->start+r->length+8,2);	/* Backoff           */

	r->length += 10;

	sent = sendto(srvport,r->start,r->length,0,&(req->fromto),S_AD_SZ);

	if(sent != r->length) return(REPLY_NOTSENT);

	ptfree(r);
	r = NULL;

	return(PSUCCESS);
    }

/*
 * transmit - transmit takes a request block that has been filed in
 * with a messages that have not yet been returned, and it transmits them
 * to the client.  If the packet sequnce number is non-zero, then a line
 * apporpirate sequencing information is added.  I the sequence
 * number is negative, then it assumes that this is the last message
 * to be returned and adds additional sequencing information indicating
 * the total number of packets.
 */
transmit(req)
    PREQ		req;
    {
	char 	buf[MAX_DIR_LINESIZE];
	int	sent;
	short	zero = 0;
	short	nseq = 0;
	short	ntotal = 0;

	*buf = '\0';

	if(!req->cpkt) return(PFAILURE);

        if(req->cpkt->seq > 0) {
	    sprintf(buf,"MULTI-PACKET %d\n",req->cpkt->seq);
	    nseq = htons((u_short) req->cpkt->seq);
	}
	else if(req->cpkt->seq < 0) {
	    sprintf(buf, "MULTI-PACKET %d OF %d",
		    -req->cpkt->seq, -req->cpkt->seq);
	    nseq = htons((u_short) -req->cpkt->seq);
	    ntotal = htons((u_short) -req->cpkt->seq);
	}
	else {
	    nseq = htons((u_short) 1);
	    ntotal = htons((u_short) 1);
	}

#ifdef REALLYNEW
	/* Note that in the following, we don't have to make sure  */
	/* there is room for the header in the packet because we   */
	/* are the only one that moves back the start, and ptalloc */
	/* allocates space for us in all packets it creates        */

	/* If a single message and no connection ID to return, */
	/* then we can leave the control fields out            */
	if(req->cpkt->seq == 0) {
	    req->cpkt->start -= 1;
	    req->cpkt->length += 1;
	    *req->cpkt->start = (char) 1;
	}
	else {	    /* Fill in the control fields */
	    req->cpkt->start -= 7;
	    req->cpkt->length += 7;
	    *req->cpkt->start = (char) 7;

	    bcopy(&zero,req->cpkt->start+1,2);     /* Conn ID */
	    bcopy(&nseq,req->cpkt->start+3,2);   /* Pkt no  */
	    bcopy(&ntotal,req->cpkt->start+5,2); /* Total   */
	}
	/* Make room for the trailing null */
	req->cpkt->length += 1;

#else /* Not really new */
#ifndef DONTSUPPORTOLD
	/* Copy the buffer and update length (count the trailing null) */
	strcat(req->cpkt->start + req->cpkt->length, buf);
	req->cpkt->length += strlen(buf) + 1;
#else
	/* Make room for the trailing null */
	req->cpkt->length += 1;
#endif

	/* If a single message and no connection ID to return, */
	/* then we can leave the control fields out            */
	if(req->cpkt->seq != 0) {
	   /* Fill in the control fields */
	   bcopy(&zero,req->cpkt->start+req->cpkt->length,2);     /* Conn ID */
	   bcopy(&nseq,req->cpkt->start+req->cpkt->length+2,2);   /* Pkt no  */
	   bcopy(&ntotal,req->cpkt->start+req->cpkt->length+4,2); /* Total   */
	   req->cpkt->length += 6;
	}
#endif

        sent = sendto(srvport, req->cpkt->start, req->cpkt->length, 
		      0, &(req->fromto), S_AD_SZ);

	if(sent != req->cpkt->length) return(REPLY_NOTSENT);

	/* If the sequence number was negative, or 0 then get */
	/* rid of the request structure.  Eventually, we will */
	/* leave it around in case we have to retry but we    */
	/* can't tell if we need to do that until client      */
	/* start filing in the connection ID                  */
	if(req->cpkt->seq <= 0) {
	    prfree(req);
	}
	else { /* Eventually add to req->trns, for now, free */
	    ptfree(req->cpkt);
	    req->cpkt = NULL;
	}
	return(PSUCCESS);
    }
