#include <stdio.h>
#include <sys/types.h>

#include <database.h>
#ifdef MMAP
#include <sys/mman.h>
#endif
#include <defines.h>
#include <structs.h>

#include <pfs.h>
#include <psite.h>
#include "prarch.h"

extern FILE *strings_table;
extern char *strings_begin;

extern char	hostname[];

char	*perms_itoa();
char	*print_date();

VLINK atoplink(sop,archiedir)
    site_out	*sop;  		/* Site output pointer                    */
    int		archiedir;	/* Flag: directory links s/b to archie    */
    {
	VLINK		vl = vlalloc();  /* New link			*/
	PATTRIB		at;	         /* Attributes                  */
	PATTRIB		last_at;	 /* Last attribute              */
	char 		fullpath[MAX_STRING_LEN];
	char 		modestring[20];
	char 		str_ent[256];
	char 		atval[256];
	char		*nameptr;        /* Last component of file name */
	char		*ptr;
	site_rec	*srp = &(sop->site_ent); /* Site record pointer */
	long		strings_pos;
	
	/* For now, all directory pointers are to pseudo-directories */
	archiedir = 1;

	if(srp->dir_or_f == 'T') {
	    /* It's a directory - we should check to see if the site is   */
	    /* running prospero, and if so return a pointer to the actual */
	    /* directory.  If it isn't then we return a real pointer to   */
	    /* a pseudo-directory maintained by this archie server.       */
	    vl->type = stcopyr("DIRECTORY",vl->type);
	}
	else {
	    /* It's a file - we should check to see if the site is        */
	    /* running prospero, and if so return a pointer to the real   */
	    /* file.  If it isn't, then we generate an external link      */
	    vl->type = stcopyr("EXTERNAL(AFTP,BINARY)",vl->type);
	    archiedir = 0;
	}
	
	if(archiedir) vl->host = stcopyr(hostname,vl->host);
	else vl->host = stcopyr(sop->site_name,vl->host);
	
	/* Get the name of the last component of name */
	
#ifndef MMAP
	
	if((strings_pos = ftell(strings_table)) == -1) return(NULL);
	if(fseek(strings_table, srp->in_or_addr.strings_ind + 
		 sizeof(strings_header), 0) == -1 ) return(NULL);
	
	if(fgets(str_ent,sizeof(str_ent),strings_table) == (char *)NULL)
	    return(NULL);

	if(fseek(strings_table,strings_pos,0) == -1) return(NULL);
	
	nameptr = str_ent;
	
#else /* defined MMAP */
	
	nameptr = strings_begin + srp->in_or_addr.strings_ind + 
	    sizeof(strings_header);
	
#endif
	
	vl->name = stcopyr(nameptr,vl->name);

	if(archiedir) {
	   sprintf(fullpath,"%s/HOST/%s%s%s%s",DATABASE_PREFIX,
		   sop->site_name, sop->site_path,
		   ((*(sop->site_path + strlen(sop->site_path) - 1) == '/') ?
		    "" : "/"), (nameptr ? nameptr : ""));
	}
	else {
	    sprintf(fullpath,"%s%s%s",sop->site_path, 
		    ((*(sop->site_path + strlen(sop->site_path) - 1) == '/') ?
		     "" : "/"), (nameptr ? nameptr : ""));
	}

	vl->filename = stcopyr(fullpath,vl->filename);
	
	/* Here we can add cached attribute values from the archie database */
	/* such as size, protection, and last modified time                 */
	at = atalloc();
	at->precedence = ATR_PREC_CACHED;
	at->aname = stcopy("SIZE");
	at->avtype = stcopy("ASCII");
	sprintf(atval,"%d bytes",srp->size);
	at->value.ascii = stcopy(atval);
	vl->lattrib = at;
	last_at = at;
	
	/* Directory modes in unix string format */
	if(ptr = perms_itoa(srp->perms)) {
	    sprintf(modestring,"%c%s",((srp->dir_or_f=='T') ? 'd' : '-'),ptr);
	    at = atalloc();
	    at->precedence = ATR_PREC_CACHED;
	    at->aname = stcopy("UNIX-MODES");
	    at->avtype = stcopy("ASCII");
	    at->value.ascii = stcopy(modestring);
	    last_at->next = at;
	    at->previous = last_at;
	    last_at = at;
	}
	
	/* Permissions - in archie format */
	if(ptr = print_date(srp->mod_time)) {
	    at = atalloc();
	    at->precedence = ATR_PREC_CACHED;
	    at->aname = stcopy("ARC-MODTIME");
	    at->avtype = stcopy("ASCII");
	    at->value.ascii = stcopy(ptr);
	    last_at->next = at;
	    at->previous = last_at;
	    last_at = at;
	}
	return(vl);
    }
    
    
    
    
    
