/*
 * Copyright (c) 1989, 1990, 1991 by the University of Washington
 *
 * For copying and distribution information, please see the file
 * <uw-copyright.h>.
 */

#include <uw-copyright.h>
#include <stdio.h>

#include <pfs.h>

static VLINK	lfree = NULL;
int		vlink_count = 0;
int		vlink_max = 0;

/*
 * vlalloc - allocate and initialize vlink structure
 *
 *    VLALLOC returns a pointer to an initialized structure of type
 *    VLINK.  If it is unable to allocate such a structure, it
 *    returns NULL.
 */
VLINK
vlalloc()
    {
	VLINK	vl;
	if(lfree) {
	    vl = lfree;
	    lfree = lfree->next;
	}
	else {
	    vl = (VLINK) malloc(sizeof(VLINK_ST));
	    if (!vl) return(NULL);
	    vlink_max++;
	}

	vlink_count++;

	/* Initialize and fill in default values */
	vl->dontfree = FALSE;
	vl->name = NULL;
	vl->linktype = 'L';
	vl->expanded = 0;
	vl->type = stcopy("FILE");
	vl->filters = NULL;
	vl->replicas = NULL;
	vl->hosttype = stcopy("INTERNET-D");
	vl->host = NULL;
	vl->nametype = stcopy("ASCII");
	vl->filename = NULL;
	vl->version = 0;
	vl->f_magic_no = 0;
	vl->acl = NULL;
	vl->dest_exp = 0;
	vl->link_exp = 0;
	vl->args = NULL;
	vl->lattrib = NULL;
	vl->f_info = NULL;
	vl->previous = NULL;
	vl->next = NULL;
	return(vl);
    }

/*
 * vlcopy - allocates a new vlink structure and
 *          initializes it with a copy of another 
 *          vlink, v.
 *
 *          If r is non-zero, successive vlinks will be
 *          iteratively copied.
 *
 *          vl-previous will always be null on the first link, and
 *          will be appropriately filled in for iteratively copied links. 
 *
 *          VLCOPY returns a pointer to the new structure of type
 *          VLINK.  If it is unable to allocate such a structure, it
 *          returns NULL.
 *
 *          VLCOPY will copy the list of filters associated with a link.
 *          It will not copy the list of replicas.
 */
VLINK
vlcopy(v,r)
	VLINK	v;
	int	r;
    {
	VLINK	nl;
	VLINK	snl;  /* Start of the chain of new links */
	VLINK	tl;   /* Temporary link pointer          */

	nl = vlalloc();
	snl = nl;

	if(!nl) return(nl);

    copyeach:

	/* Copy v into nl */
	if(v->name) nl->name = stcopyr(v->name,nl->name);
	nl->linktype = v->linktype;
	nl->expanded = v->expanded;
	nl->type = stcopyr(v->type,nl->type);
	nl->hosttype = stcopyr(v->hosttype,nl->hosttype);
	if(v->host) nl->host = stcopyr(v->host,nl->host);
	nl->nametype = stcopyr(v->nametype,nl->nametype);
	if(v->filename) nl->filename = stcopyr(v->filename,nl->filename);
	nl->version = v->version;
	nl->f_magic_no = v->f_magic_no;
	nl->acl = NULL;
	nl->dest_exp = v->dest_exp;
	nl->link_exp = v->link_exp;
	if(v->args) nl->args = stcopyr(v->args,nl->args);
	if(v->filters) nl->filters = vlcopy(v->filters,1);
	/* Still need to handle lattrib and f_info */
	if(r && v->next) {
	    v = v->next;
	    tl = nl;
	    nl = vlalloc();
	    if(!nl) return(nl);
	    nl->previous = tl;
	    tl->next = nl;
	    goto copyeach;
	}

	return(snl);
    }

/*
 * vlfree - free a VLINK structure
 *
 *    VLFREE takes a pointer to a VLINK structure and adds it to
 *    the free list for later reuse.
 */
vlfree(vl)
    VLINK	vl;
    {
	if(vl->dontfree) return;
	if(vl->name) stfree(vl->name);
	stfree(vl->type);
	if(vl->filters) vllfree(vl->filters);
	if(vl->replicas) vllfree(vl->replicas);
	stfree(vl->hosttype);
	if(vl->host) stfree(vl->host);
	stfree(vl->nametype);
	if(vl->filename) stfree(vl->filename);
	if(vl->acl) aclfree(vl->acl);
	if(vl->args) stfree(vl->args);
	if(vl->lattrib) atlfree(vl->lattrib);
	/* No allocation routines for f_info yet */
	vl->f_info = NULL;
	vl->next = lfree;
	vl->previous = NULL;
	lfree = vl;
	vlink_count--;
    }

/*
 * vllfree - free a VLINK structure
 *
 *    VLLFREE takes a pointer to a VLINK structure frees it and any linked
 *    VLINK structures.  It is used to free an entrie list of VLINK
 *    structures.
 */
vllfree(vl)
    VLINK	vl;
    {
	VLINK	nxt;

	while((vl != NULL) && !vl->dontfree) {
	    nxt = vl->next;
	    vlfree(vl);
	    vl = nxt;
	}
    }

