/*
 * Copyright (c) 1989, 1990, 1991 by the University of Washington
 *
 * For copying and distribution information, please see the file
 * <uw-copyright.h>.
 */

#include <uw-copyright.h>
#include <stdio.h>

#include <pfs.h>

static PREQ	free = NULL;
int 		preq_count = 0;
int		preq_max = 0;

/*
 * pralloc - allocate and initialize preq structure
 *
 *    PRALLOC returns a pointer to an initialized structure of type
 *    PREQ.  If it is unable to allocate such a structure, it
 *    returns NULL.
 */
PREQ
pralloc()
    {
	PREQ	pr;
	if(free) {
	    pr = free;
	    free = free->next;
	}
	else {
	    pr = (PREQ) malloc(sizeof(PREQ_ST));
	    if (!pr) return(NULL);
	    preq_max++;
	}
	preq_count++;

	pr->cid = 0;
	pr->recv_tot = 0;
	pr->trns_tot = 0;
	pr->cpkt = NULL;
	pr->recv = NULL;
	pr->trns = NULL;
	pr->rcvd_thru = 0;
	pr->previous = NULL;
	pr->next = NULL;
	bzero(&(pr->fromto),sizeof(pr->fromto));
	return(pr);
    }

/*
 * prfree - free a PREQ structure
 *
 *    PRFREE takes a pointer to a PREQ structure and adds it to
 *    the free list for later reuse.
 */
prfree(pr)
    PREQ	pr;
    {
	if(pr->cpkt) ptlfree(pr->cpkt);
	if(pr->recv) ptlfree(pr->recv);
	if(pr->trns) ptlfree(pr->trns);
	pr->next = free;
	pr->previous = NULL;
	free = pr;
	preq_count--;
    }

/*
 * prlfree - free a PREQ structure
 *
 *    PRLFREE takes a pointer to a PREQ structure frees it and any linked
 *    PREQ structures.  It is used to free an entrie list of PREQ
 *    structures.
 */
prlfree(pr)
    PREQ	pr;
    {
	PREQ	nxt;

	while(pr != NULL) {
	    nxt = pr->next;
	    prfree(pr);
	    pr = nxt;
	}
    }

