/*
 * Copyright (c) 1989, 1990, 1991 by the University of Washington
 *
 * For copying and distribution information, please see the file
 * <uw-copyright.h>.
 */

#include <uw-copyright.h>
#include <stdio.h>
#include <strings.h>

#include <pfs.h>
#include <psite.h>
#include <pprot.h>
#include <perrno.h>
#include <pauthent.h>
#include <pmachine.h>

extern int	pfs_debug;

pget_am(link,ainfo,methods)
    VLINK	link;
    char	*ainfo;
    int		methods;
    {
        PTEXT	request;	/* Text of request to dir server             */
	PTEXT	resp;	    	/* Response from dir server	             */

	PAUTH	authinfo;
	char	am[MAX_DIR_LINESIZE];
	char	amparam[MAX_DIR_LINESIZE];

	char	fwdhst[MAX_DIR_LINESIZE];
	char	fwdfnm[MAX_DIR_LINESIZE];

	perrno = PSUCCESS;

	if(strcmp(link->type,"NULL") == 0) return(0);

	if(sscanf(link->type,"EXTERNAL(%[^,)],%[^)]",am,amparam) > 0) {
	    
	    if((methods & P_AM_NFS) && (strcmp(am,"NFS") == 0)) {
		sprintf(ainfo,"%s %s",amparam,link->filename);
		return(P_AM_NFS);
	    }
	    if((methods & P_AM_AFTP) && (strcmp(am,"AFTP") == 0)) {
		sprintf(ainfo,"%s %s",link->filename,amparam);
		return(P_AM_AFTP);
	    }
	    return(0);
	}

	authinfo = get_pauth(PFSA_UNAUTHENTICATED);

    startover:

	request = ptalloc();

#ifndef OLDVERS
	sprintf(request->start,
          "VERSION %d\nAUTHENTICATOR %s %s\nGET-OBJECT-INFO ACCESS-METHOD ID ASCII %s 0 %d\n",
#else
	sprintf(request->start,
          "VERSION %d\nAUTHENTICATOR %s %s\nGET-OBJECT-INFO ACCESS-METHODS ID ASCII %s 0 %d\n",
#endif
		VFPROT_VNO, authinfo->auth_type, authinfo->authenticator,
		link->filename, link->f_magic_no);
	
	request->length = strlen(request->start);

	if(pfs_debug > 2)
	    fprintf(stderr,"Sending message to dirsrv:\n%s",request->start);

	resp = dirsend(request,link->host,0);

	ptlfree(request);

	if(pfs_debug && (resp == NULL)) {
	    fprintf(stderr,"Dirsend failed: %d\n",perrno);
	}


	/* If we don't get a response, then no method, error */
	/* code already in perrno, just return NULL          */
	if(resp == NULL) return(NULL);


	/* Here we must parse reponse   */
	/* While looking at each packet */
	while(resp) {
	    PTEXT		vtmp;
	    char		*line;

	    vtmp = resp;

	    if(pfs_debug > 3) fprintf(stderr,"%s\n",resp->start);

	    /* Look at each line in packet */
	    for(line = resp->start;line != NULL;line = nxtline(line)) {
		switch (*line) {
		    
		    /* Temporary variables to info */
		    char	*ts; /* temporary string */
		    int		tmp;

		case 'O': /* OBJECT-INFO */

		    /* parse line */
#ifndef OLDVERS
		    tmp = sscanf(line,"OBJECT-INFO ACCESS-METHOD ASCII %s", am);
#else
		    tmp = sscanf(line,"OBJECT-INFO ACCESS-METHOD %s", am);
#endif
		    if(tmp < 1) {
			perrno = DIRSRV_BAD_FORMAT;
			break;
		    }

		    if(strncmp(am,"NFS",3) == 0) {
			if(methods & P_AM_NFS) {
			    ts = index(line,'\n');
			    if(ts) *ts = '\0';
#ifndef OLDVERS
			    if(ainfo) strcpy(ainfo,line+33+strlen(am));
#else
			    if(ainfo) strcpy(ainfo,line+27+strlen(am));
#endif
			    return(P_AM_NFS);
			}
		    }
#ifdef P_AFS
		    else if(strncmp(am,"AFS",3) == 0) {
			if(methods & P_AM_AFS) {
			    ts = index(line,'\n');
			    if(ts) *ts = '\0';
#ifndef OLDVERS
			    if(ainfo) strcpy(ainfo,line+33+strlen(am));
#else
			    if(ainfo) strcpy(ainfo,line+27+strlen(am));
#endif
			    return(P_AM_AFS);
			}
		    }
#endif P_AFS
		    else if(strncmp(am,"ANONYMOUS-FTP",13) == 0) {
			if(methods & P_AM_AFTP) {
			    ts = index(line,'\n');
			    if(ts) *ts = '\0';
#ifndef OLDVERS
			    if(ainfo) strcpy(ainfo,line+33+strlen(am));
#else
			    if(ainfo) strcpy(ainfo,line+27+strlen(am));
#endif
			    return(P_AM_AFTP);
			}
		    }

		    break;

		case 'M': /* MULTI-PACKET (processed by dirsend) */
		case 'P': /* PACKET (processed by dirsend) */
		    break;

		case 'E': /* ERROR */
		    if(strncmp(line,"ERROR",5) == 0) {
			perrno = DIRSRV_ERROR;
			strncpy(p_err_string,line+6,P_ERR_STRING_SZ);
			return(NULL);
		    }
		    perrno = DIRSRV_BAD_FORMAT;
		    break;

		case 'F':/* FORWARDED */
		    if(strncmp(line,"FORWARDED",9) == 0) {
			/* parse and start over */

			tmp = sscanf(line,"FORWARDED %*s %s %*s %s %d %d", 
				     fwdhst,fwdfnm,
				     &(link->version), &(link->f_magic_no));

			link->host = stcopyr(fwdhst,link->host);
			link->filename = stcopyr(fwdfnm,link->filename);

			if(tmp < 2) {
			    perrno = DIRSRV_BAD_FORMAT;
			    break;
			}
			
			ptlfree(resp);
			goto startover;
		    }
		    perrno = DIRSRV_BAD_FORMAT;
		    break;

		case 'V': /* VERSION-NOT-SUPPORTED */
		    if(strncmp(line,"VERSION-NOT-SUPPORTED",21) == 0) {
			perrno = DIRSRV_BAD_VERS;
			return(NULL);
		    }
		    perrno = DIRSRV_BAD_FORMAT;
		    break;

		default:
		    if(*line) perrno = DIRSRV_BAD_FORMAT;
		    break;
		}
	    }

	    resp = resp->next;

	    ptfree(vtmp);
	}


	ptlfree(resp);

	return(NULL);
    }

	    
