/*
 * Copyright (c) 1991 by the University of Washington
 *
 * For copying and distribution information, please see the file
 * <uw-copyright.h>.
 */

#include <uw-copyright.h>
#include <pcompat.h>
#include <pfs.h>
#include <psite.h>
#include <pmachine.h>

char	*getenv();

static char	vsroot_host[MAX_VPATH] = "";
static char	vsroot_file[MAX_VPATH] = "";

static char	vswork_host[MAX_VPATH] = "";
static char	vswork_file[MAX_VPATH] = "";
static char	vswork[MAX_VPATH] = "";

static char	vshome_host[MAX_VPATH] = "";
static char	vshome_file[MAX_VPATH] = "";
static char	vshome[MAX_VPATH] = "";

static char	vsdesc_host[MAX_VPATH] = "";
static char	vsdesc_file[MAX_VPATH] = "";
static char	vsname[MAX_VPATH] = "";

/* 
 * Note that there is one more environment variable used, PFS_DEFAULT,
 * but that environment variable is per process and is handled in the
 * pcompat library.
 */



pset_wd(wdhost,wdfile,wdname)
    char	*wdhost;
    char	*wdfile;
    char	*wdname;
    {
	if(wdhost) {
	    strcpy(vswork_host,wdhost);
	    setenv("VSWORK_HOST",wdhost,1);
	}
	if(wdfile) {
	    strcpy(vswork_file,wdfile);
	    setenv("VSWORK_FILE",wdfile,1);
	}
	if(wdname) {
	    strcpy(vswork,wdname);
	    setenv("VSWORK",wdname,1);
	}
    }

char * pget_wdhost()
    {
	char	*env_st;
	if(!*vswork_host && (env_st = getenv("VSWORK_HOST"))) 
	    strcpy(vswork_host,env_st);
	if(*vswork_host) return(vswork_host);
	else return(NULL);
    }

char * pget_wdfile()
    {
	char	*env_st;
	if(!*vswork_file && (env_st = getenv("VSWORK_FILE"))) 
	    strcpy(vswork_file,env_st);
	if(*vswork_file) return(vswork_file);
	else return(NULL);
    }

char * pget_wd()
    {
	char	*env_st;
	if(!*vswork && (env_st = getenv("VSWORK"))) 
	    strcpy(vswork,env_st);
	if(*vswork) return(vswork);
	else return(NULL);
    }

pset_hd(hdhost,hdfile,hdname)
    char	*hdhost;
    char	*hdfile;
    char	*hdname;
     {
	if(hdhost) {
	    strcpy(vshome_host,hdhost);
	    setenv("VSHOME_HOST",hdhost,1);
	}
	if(hdfile) {
	    strcpy(vshome_file,hdfile);
	    setenv("VSHOME_FILE",hdfile,1);
	}
	if(hdname) {
	    strcpy(vshome,hdname);
	    setenv("VSHOME",hdname,1);
	}
    }

char * pget_hdhost()
    {
	char	*env_st;
	if(!*vshome_host && (env_st = getenv("VSHOME_HOST"))) 
	    strcpy(vshome_host,env_st);
	if(*vshome_host) return(vshome_host);
	else return(NULL);
    }

char * pget_hdfile()
    {
	char	*env_st;
	if(!*vshome_file && (env_st = getenv("VSHOME_FILE"))) 
	    strcpy(vshome_file,env_st);
	if(*vshome_file) return(vshome_file);
	else return(NULL);
    }

char * pget_hd()
    {
	char	*env_st;
	if(!*vshome && (env_st = getenv("VSHOME"))) 
	    strcpy(vshome,env_st);
	if(*vshome) return(vshome);
	else return(NULL);
    }

pset_rd(rdhost,rdfile)
    char	*rdhost;
    char	*rdfile;
     {
	if(rdhost) {
	    strcpy(vsroot_host,rdhost);
	    setenv("VSROOT_HOST",rdhost,1);
	}
	if(rdfile) {
	    strcpy(vsroot_file,rdfile);
	    setenv("VSROOT_FILE",rdfile,1);
	}
    }

char * pget_rdhost()
    {
	char	*env_st;
	if(!*vsroot_host && (env_st = getenv("VSROOT_HOST"))) 
	    strcpy(vsroot_host,env_st);
	if(*vsroot_host) return(vsroot_host);
	else return(NULL);
    }

char * pget_rdfile()
    {
	char	*env_st;
	if(!*vsroot_file && (env_st = getenv("VSROOT_FILE"))) 
	    strcpy(vsroot_file,env_st);
	if(*vsroot_file) return(vsroot_file);
	else return(NULL);
    }

pset_desc(dhost,dfile,vsnm)
    char	*dhost;
    char	*dfile;
    char	*vsnm;
     {
	if(dhost) {
	    strcpy(vsdesc_host,dhost);
	    setenv("VSDESC_HOST",dhost,1);
	}
	if(dfile) {
	    strcpy(vsdesc_file,dfile);
	    setenv("VSDESC_FILE",dfile,1);
	}
	if(vsnm) {
	    strcpy(vsname,vsnm);
	    setenv("VSNAME",vsnm,1);
	}
    }

char * pget_dhost()
    {
	char	*env_st;
	if(!*vsdesc_host && (env_st = getenv("VSDESC_HOST"))) 
	    strcpy(vsdesc_host,env_st);
	if(*vsdesc_host) return(vsdesc_host);
	else return(NULL);
    }

char * pget_dfile()
    {
	char	*env_st;
	if(!*vsdesc_file && (env_st = getenv("VSDESC_FILE"))) 
	    strcpy(vsdesc_file,env_st);
	if(*vsdesc_file) return(vsdesc_file);
	else return(NULL);
    }

char * pget_vsname()
    {
	char	*env_st;
	if(!*vsname && (env_st = getenv("VSNAME"))) 
	    strcpy(vsname,env_st);
	if(*vsname) return(vsname);
	else return(NULL);
    }

/*
 * Pprint shell string prints command on the standard output which when
 * interpreted by the shell will set environment variable and define
 * aliases needed to pass the prospero environment from program to
 * program.  This routine is called by vfsetup and vcd.
 *
 * The argument is a bit vector indicating which variable should be set.
 * The low order bit is (0x0):
 * 
 *    0x01   Print aliases
 *    0x02   Print virtual system description
 *    0x04   Print working directory
 *    0x08   Print home directory
 *    0x10   Print root directory
 */
pprint_shellstring(which)
    int		which;
    {
	if(which & 0x2) {
#ifdef CSH	    
	    printf("setenv VSDESC_HOST %s;\n",pget_dhost());
	    printf("setenv VSDESC_FILE %s;\n",pget_dfile());
	    printf("setenv VSNAME \\%s;\n",pget_vsname());
#endif
#ifdef SH
	    printf("VSDESC_HOST=%s;export VSDESC_HOST\n",pget_dhost());
	    printf("VSDESC_FILE=%s;export VSDESC_FILE\n",pget_dfile());
	    printf("VSNAME=\\%s;export VSNAME\n",pget_vsname());
#endif
	}
	if(which & 0x4) {
#ifdef CSH
	    printf("setenv VSWORK_HOST %s;\n",pget_wdhost());
	    printf("setenv VSWORK_FILE \"%s\";\n",pget_wdfile());
	    printf("setenv VSWORK \"%s\";\n",pget_wd());
#endif
#ifdef SH
	    printf("VSWORK_HOST=%s;export VSWORK_HOST\n",pget_wdhost());
	    printf("VSWORK_FILE=\"%s\";export VSWORK_FILE\n",pget_wdfile());
	    printf("VSWORK=\"%s\";export VSWORK\n",pget_wd());
#endif
	}
	if(which & 0x8) {
#ifdef CSH
	    printf("setenv VSHOME_HOST %s;\n",pget_hdhost());
	    printf("setenv VSHOME_FILE \"%s\";\n",pget_hdfile());
	    printf("setenv VSHOME \"%s\";\n",pget_hd());
#endif
#ifdef SH
	    printf("VSHOME_HOST=%s;export VSHOME_HOST\n",pget_hdhost());
	    printf("VSHOME_FILE=\"%s\";export VSHOME_FILE\n",pget_hdfile());
	    printf("VSHOME=\"%s\";export VSHOME\n",pget_hd());
#endif SH
	}
	if(which & 0x10) {
#ifdef CSH
	    printf("setenv VSROOT_HOST %s;\n",pget_rdhost());
	    printf("setenv VSROOT_FILE \"%s\";\n",pget_rdfile());
#endif CSH
#ifdef SH
	    printf("VSROOT_HOST=%s;export VSROOT_HOST\n",pget_rdhost());
	    printf("VSROOT_FILE=\"%s\";export VSROOT_FILE\n",pget_rdfile());
#endif SH
	}
	if(which & 0x1) {
#ifdef CSH
	    printf("alias vwd 'echo $VSWORK';\n");
	    printf("alias vwp 'echo $VSWORK_HOST $VSWORK_FILE';\n");
	    printf("alias vwho 'echo $VSNAME';\n");
	    printf("alias vcd 'eval `%s/vcd \\!*`';\n",P_BINARIES);
	
#ifndef P_NO_PCOMPAT
	    printf("alias venable 'setenv PFS_DEFAULT %d;if($?Poldcd == 0) set Poldcd = `alias cd`;alias pwd vwd;alias cd vcd';\n",PMAP_ATSIGN);
	    printf("set Presetcd = 'unalias cd;alias cd $Poldcd;unset Poldcd';\n");
	    printf("alias vdisable 'unsetenv PFS_DEFAULT;unalias pwd;if($?Poldcd) eval $Presetcd';\n");
#endif P_NO_PCOMPAT

#endif CSH
#ifdef SH
	    printf("vwd () { echo $VSWORK }\n");
	    printf("vwp () { echo $VSWORK_HOST $VSWORK_FILE }\n");
	    printf("vwho () { echo $VSNAME }\n");
	    printf("vcd () { eval `%s/vcd $*` }\n",P_BINARIES);

#ifndef P_NO_PCOMPAT
#endif  P_NO_PCOMPAT
	    /* Note that this will bash any existing cd alias */
    printf("venable () { PFS_DEFAULT=%d;export PFS_DEFAULT;alias cd=vcd;alias pwd=vwd }\n",PMAP_ATSIGN);
	    printf("vdisable () { unset PFS_DEFAULT;unalias cd; unalias pwd }\n");
#endif SH
	}

	return(PSUCCESS);
    }


#ifdef PUTENV
static setenv(n,v,o)
    char	*n;
    char	*v;
    int		o;
    {
	int	tmp;

	/* Allocate space for environment variable */
	char	*template = (char *) stalloc(strlen(n)+strlen(v)+2);
	
	sprintf(template,"%s=%s",n,v);
	tmp = putenv(template);
	return(tmp);

	/* Potential memory leak - it is not clear whether putenv     */
	/* deallocates the string with the old value of the           */
	/* envorinment variable. If not, then we should do so here.   */

    }
#endif PUTENV
