/*
 * Copyright (c) 1991 by the University of Washington
 *
 * For copying and distribution information, please see the file
 * <uw-copyright.h>.
 */

#include <uw-copyright.h>
#include <stdio.h>
#include <strings.h>

#include <pfs.h>
#include <pprot.h>
#include <perrno.h>
#include <pauthent.h>

extern int	pfs_debug;
extern char	*acltypes[];

/*
 *
 *   Flags:      
 */
modify_acl(dlink,lname,a,flags)
    VLINK	dlink;		/* Directory link                 */
    char	*lname;		/* Link name                      */
    ACL		a;		/* ACL entry to add/delete/modify */
    int		flags;		/* Flags                          */
    {
        PTEXT	request;	/* Text of request to dir server             */
	PTEXT	resp;	    	/* Response from dir server	             */
	char	options[100];   /* List of options                           */
	char	*optptr;        /* Options minus leading + */
	int	tmp;           

	char	qlname[MAX_DIR_LINESIZE]; /* Quoted link name */
	char	qatype[MAX_DIR_LINESIZE]; /* Quoted auth type */
	char	qrights[MAX_DIR_LINESIZE]; /* Quoted auth type */

	char	fwdhst[MAX_DIR_LINESIZE];
	char	fwdfnm[MAX_DIR_LINESIZE];

	PAUTH	authinfo;

	*options = '\0';

	if(flags&MACL_NOSYSTEM) strcat(options,"+NOSYSTEM");
	if(flags&MACL_NOSELF) strcat(options,"+NOSELF");
	if(!((flags&MACL_OP)^MACL_DEFAULT)) strcat(options,"+DEFAULT");
	if(!((flags&MACL_OP)^MACL_SET)) strcat(options,"+SET");
	if(!((flags&MACL_OP)^MACL_INSERT)) strcat(options,"+INSERT");
	if(!((flags&MACL_OP)^MACL_DELETE)) strcat(options,"+DELETE");
	if(!((flags&MACL_OP)^MACL_ADD)) strcat(options,"+ADD");
	if(!((flags&MACL_OP)^MACL_SUBTRACT)) strcat(options,"+SUBTRACT");
	if(!((flags&MACL_OTYPE)^MACL_LINK)) strcat(options,"+LINK");
	if(!((flags&MACL_OTYPE)^MACL_DIRECTORY)) strcat(options,"+DIRECTORY");
	if(!((flags&MACL_OTYPE)^MACL_OBJECT)) strcat(options,"+OBJECT");
	if(!((flags&MACL_OTYPE)^MACL_INCLUDE)) strcat(options,"+INCLUDE");

	optptr = options + 1;

	if(lname == NULL) lname = "";

	if(strcmp(dlink->type,"NULL") == 0) return(PFS_EXT_USED_AS_DIR);
	if(strcmp(dlink->type,"EXTERNAL") == 0) return(PFS_EXT_USED_AS_DIR);

	authinfo = get_pauth(PFSA_UNAUTHENTICATED);

    startover:

	request = ptalloc();

	strcpy(qlname,quote(lname));
	strcpy(qatype,quote(a->atype));
	strcpy(qrights,quote(a->rights));

	sprintf(request->start,
		"VERSION %d\nAUTHENTICATOR %s %s\nDIRECTORY ASCII %s\nMODIFY-ACL %s %s %s %s %s %s\n",
		VFPROT_VNO, authinfo->auth_type, authinfo->authenticator,
		dlink->filename, optptr, qlname, acltypes[a->acetype],
		qatype, qrights, quote(a->principals));
	
	request->length = strlen(request->start);

	if(pfs_debug > 2)
	    fprintf(stderr,"Sending message to dirsrv:\n%s",request->start);

	perrno = 0;
	resp = dirsend(request,dlink->host,0);

	ptlfree(request);

	if(pfs_debug && (resp == NULL)) {
	    fprintf(stderr,"Dirsend failed: %d\n",perrno);
	}

	/* If we don't get a response, then return error */
	if(resp == NULL) return(perrno);

	/* Here we parse the response.  Right now we just check the */
	/* first packet.  For this request, it should not take      */
	/* any more than one. If SUCCESS, then we were successful   */
	/* if FAILURE, or anything else, we failed, and should      */
        /* return an appropriate error                              */

	if(pfs_debug > 3) fprintf(stderr,"%s\n",resp->start);

	if(*(resp->start) != 'S') {
	    /* FORWARDED */
	    if(strncmp(resp->start,"FORWARDED",9) == 0) {
		/* parse and start over */

		tmp = sscanf(resp->start,"FORWARDED %*s %s %*s %s %*d %*d", 
			     fwdhst,fwdfnm);

		dlink->host = stcopyr(fwdhst,dlink->host);
		dlink->filename = stcopyr(fwdfnm,dlink->filename);

		ptlfree(resp);

		if(tmp < 2) return(DIRSRV_BAD_FORMAT);
		else goto startover;
	    }

	    tmp = scan_error(resp->start);

	    if(pfs_debug)
		fprintf(stderr,"MODIFY-ACL: %s\n",resp->start);
	    
	    ptlfree(resp);
	    return(tmp);
	}
	    
	ptlfree(resp);
	return(PSUCCESS);
    }
