/*
 * Copyright (c) 1989, 1990 by the University of Washington
 *
 * For copying and distribution information, please see the file
 * <uw-copyright.h>.
 */

#include <uw-copyright.h>
#include <stdio.h>
#include <strings.h>

#include <pfs.h>
#include <pprot.h>
#include <perrno.h>
#include <pauthent.h>
#include <pmachine.h>

extern int	pfs_debug;

extern int	perrno;
extern		char p_err_string[];

/*
 */
mk_vdir(vpath,flags)
    char	*vpath;		/* Name of the new directory       */ 
    int		flags;		/* Options for directory           */
    {

	char		*dirhst;	   /* Host of current directory    */
	char		*remdir;	   /* Dir on remote host	   */
	
	char		*cname = "";	   /* Component name               */
        char	        *pname = "";	   /* Parent name		   */

	char		pathcpy[MAX_VPATH];

	char		fwdhst[MAX_DIR_LINESIZE];
	char		fwdfnm[MAX_DIR_LINESIZE];

        PTEXT	request;	/* Text of request to dir server             */
	PTEXT	resp;	    	/* Response from dir server	             */

	VDIR_ST		dir_st;
	VDIR		dir = &dir_st;

	PAUTH		authinfo;

	int		tmp;

	vdir_init(dir);

	strcpy(pathcpy,vpath);
	cname = rindex(pathcpy,'/');
	if(!cname)  cname = pathcpy;
	else {
	    *cname++ = '\0';
	    pname = pathcpy;
	    if(cname == (pname + 1)) pname = "/";
	}


        /* We must first find the directory into which the link  */
        /* will be inserted                                      */

	tmp = rd_vdir(pname,0,dir,RVD_DFILE_ONLY);
	if (tmp || (dir->links == NULL)) return(DIRSRV_NOT_DIRECTORY);
	dirhst = dir->links->host;
	remdir = dir->links->filename;

    startover:

	request = ptalloc();

	authinfo = get_pauth(PFSA_UNAUTHENTICATED);

	sprintf(request->start,
          "VERSION %d\nAUTHENTICATOR %s %s\nDIRECTORY ASCII %s\nCREATE-DIRECTORY VIRTUAL%s %s\n",
		VFPROT_VNO, authinfo->auth_type, authinfo->authenticator,
		remdir, ((flags&MKVD_LPRIV) ? "+LPRIV" : ""), cname);
	
	request->length = strlen(request->start);

	if(pfs_debug > 2)
	    fprintf(stderr,"Sending message to dirsrv:\n%s",request->start);

	resp = dirsend(request,dirhst,0);

	ptlfree(request);

	if(pfs_debug && (resp == NULL)) {
	    fprintf(stderr,"Dirsend failed: %d\n",perrno);
	}

	if(resp == NULL) return(perrno);

	/* Here we parse the response.  Right now we just check the */
	/* first packet.  For this request, it should not take      */
	/* any more than one. If SUCCESS, then we were successful   */
	/* if FAILURE, or anything else, we failed, and should      */
        /* return an appropriate error                              */

	if(pfs_debug > 3) fprintf(stderr,"%s\n",resp->start);

	if(*(resp->start) != 'S') {

	    /* FORWARDED */
	    if(strncmp(resp->start,"FORWARDED",9) == 0) {
		/* parse and start over */

		tmp = sscanf(resp->start,"FORWARDED %*s %s %*s %s %*d %*d", 
			     fwdhst,fwdfnm);

		dirhst = stcopy(fwdhst);
		remdir = stcopy(fwdfnm);

		ptlfree(resp);

		if(tmp < 2) return(DIRSRV_BAD_FORMAT);
		else goto startover;
	    }

	    tmp = scan_error(resp->start);

	    if(pfs_debug)
		fprintf(stderr,"CREATE-DIRECTORY: %s\n",resp->start);
	    
	    ptlfree(resp);
	    return(tmp);
	}
	    
	ptlfree(resp);
	return(PSUCCESS);
    }

