/*
 * Copyright (c) 1991 by the University of Washington
 *
 * For copying and distribution information, please see the file
 * <uw-copyright.h>.
 */

#include <uw-copyright.h>
#include <stdio.h>
#include <strings.h>

#include <pfs.h>
#include <pprot.h>
#include <perrno.h>
#include <pauthent.h>

extern int	pfs_debug;
extern	char	*acltypes[];

ACL get_acl(dlink,lname,flags)
    VLINK	dlink;
    char	*lname;
    int		flags;          /* 0 = directory, 1 = link, 2 = object       */
    {
        PTEXT	request;	/* Text of request to dir server             */
	PTEXT	resp;	    	/* Response from dir server	             */
	ACL	astart = NULL;	/* Start of list of acl                      */
	ACL	ap;		/* Temporary acl pointer                     */
	ACL     alast = NULL;	/* Last acl filled in    		     */
	char	*options = "";  /* List of options                           */

	char	fwdhst[MAX_DIR_LINESIZE];
	char	fwdfnm[MAX_DIR_LINESIZE];

	PAUTH	authinfo;

	if(flags == 0) options = "DIRECTORY";
	else if (flags == 1) options = "LINK";
	else if (flags == 2) options = "OBJECT";
	else if (flags == 3) options = "INCLUDE";

	if(lname == NULL) lname = "";

	if(strcmp(dlink->type,"NULL") == 0) return(NULL);
	if(strcmp(dlink->type,"EXTERNAL") == 0) return(NULL);

	authinfo = get_pauth(PFSA_UNAUTHENTICATED);

    startover:

	request = ptalloc();

	sprintf(request->start,
		"VERSION %d\nAUTHENTICATOR %s %s\nDIRECTORY ASCII %s\nLIST-ACL %s%s%s\n",
		VFPROT_VNO, authinfo->auth_type, authinfo->authenticator,
		dlink->filename, options, (*lname ? " " : ""), lname);
	
	request->length = strlen(request->start);

	if(pfs_debug > 2)
	    fprintf(stderr,"Sending message to dirsrv:\n%s",request->start);

	perrno = 0;
	resp = dirsend(request,dlink->host,0);

	ptlfree(request);

	if(pfs_debug && (resp == NULL)) {
	    fprintf(stderr,"Dirsend failed: %d\n",perrno);
	}

	/* If we don't get a response, then return error */
	if(resp == NULL) return(NULL);

	/* Here we must parse reponse   */
	/* While looking at each packet */
	while(resp) {
	    PTEXT		vtmp;
	    char		*line;
	    int			acltype;
	    char		acltypest[MAX_DIR_LINESIZE];
	    char		atype[MAX_DIR_LINESIZE];
	    char		rights[MAX_DIR_LINESIZE];
	    char		principals[MAX_DIR_LINESIZE];
	    
	    vtmp = resp;

	    if(pfs_debug > 3) fprintf(stderr,"%s\n",resp->start);

	    /* Look at each line in packet */
	    for(line = resp->start;line != NULL;line = nxtline(line)) {
		switch (*line) {
		    
		    /* Temporary variables to info */
		    int		tmp;

		case 'A': /* ACL */ 

		    /* parse line */
		    tmp = sscanf(line,"ACL %s %s %s %[^\n]", acltypest,
				 atype, rights, principals);

		    if(tmp < 4) {
			perrno = DIRSRV_BAD_FORMAT;
			break;
		    }

		    ap = acalloc();

		    for(acltype = 0;acltypes[acltype];acltype++) {
			if(strcmp(acltypes[acltype],acltypest) == 0)
			    break;
		    }

		    if(acltypes[acltype]) ap->acetype = acltype;
		    else ap->acetype = 0;

		    ap->atype = stcopyr(unquote(atype),ap->atype);
		    ap->rights = stcopyr(unquote(rights),ap->rights);
		    ap->principals = stcopyr(unquote(principals),ap->principals);

		    if(astart) {
			ap->previous = alast;
			alast->next = ap;
			alast = ap;
		    }
		    else {
			astart = ap;
			alast = ap;
			ap->previous = NULL;
		    }
		    break;

		case 'M': /* MULTI-PACKET (processed by dirsend) */
		case 'P': /* PACKET (processed by dirsend) */
		    break;

		case 'E': /* ERROR */
		    if(strncmp(line,"ERROR",5) == 0) {
			perrno = DIRSRV_ERROR;
			strncpy(p_err_string,line+6,P_ERR_STRING_SZ);
			return(NULL);
		    }
		    perrno = DIRSRV_BAD_FORMAT;
		    break;

		case 'F':/* FORWARDED */
		    if(strncmp(line,"FORWARDED",9) == 0) {
			/* parse and start over */

			tmp = sscanf(line,"FORWARDED %*s %s %*s %s %d %d", 
				     fwdhst,fwdfnm,
				     &(dlink->version), &(dlink->f_magic_no));

			dlink->host = stcopyr(fwdhst,dlink->host);
			dlink->filename = stcopyr(fwdfnm,dlink->filename);

			if(tmp < 2) {
			    perrno = DIRSRV_BAD_FORMAT;
			    break;
			}
			
			ptlfree(resp);
			goto startover;
		    }
		    /* Continue through to next case */
		case 'N': /* Not a directory and continuation of 'F' */
		    tmp = scan_error(line);

		    if(pfs_debug)
			fprintf(stderr,"LIST-ACL: %s\n",line);
	    
		    perrno = tmp;
		    break;

		case 'V': /* VERSION-NOT-SUPPORTED */
		    if(strncmp(line,"VERSION-NOT-SUPPORTED",21) == 0) {
			perrno = DIRSRV_BAD_VERS;
			return(NULL);
		    }
		    perrno = DIRSRV_BAD_FORMAT;
		    break;

		default:
		    if(*line) perrno = DIRSRV_BAD_FORMAT;
		    break;
		}
	    }

	    resp = resp->next;

	    ptfree(vtmp);
	}


	ptlfree(resp);

	return(astart);
    }

	    
