/*
 * Copyright (c) 1989, 1990 by the University of Washington
 *
 * For copying and distribution information, please see the file
 * <uw-copyright.h>.
 */

#include <uw-copyright.h>
#include <stdio.h>
#include <strings.h>

#include <pfs.h>
#include <pprot.h>
#include <perrno.h>
#include <pauthent.h>

extern int	pfs_debug;

/*
 */
add_vlink(direct,lname,l,flags)
    char	*direct;	/* Virtual name for the directory	     */
    char	*lname;		/* Name of the new link                      */
    VLINK	l;		/* Link to be inserted                       */
    int		flags;		/* Options for link to add 		     */
    {
	char		*dirhst;	   /* Host of current directory    */
	char		*remdir;	   /* Dir on remote host	   */
	VDIR_ST		dir_st;
	VDIR		dir = &dir_st;

        PTEXT		request;	/* Text of request to dir server    */
	PTEXT		resp;	    	/* Response from dir server	    */

	char		fwdhst[MAX_DIR_LINESIZE];
	char		fwdfnm[MAX_DIR_LINESIZE];

	PAUTH		authinfo;

	int		tmp;

	vdir_init(dir);

	/* If magic number has been modified, set it back to 0 */
	if(l->f_magic_no < 0) l->f_magic_no = 0;

        /* We must first find the directory into which the link  */
        /* will be inserted                                      */

	tmp = rd_vdir(direct,0,dir,RVD_DFILE_ONLY);
	if (tmp || (dir->links == NULL)) return(DIRSRV_NOT_DIRECTORY);
	dirhst = dir->links->host;
	remdir = dir->links->filename;

    startover:

	request = ptalloc();

	authinfo = get_pauth(PFSA_UNAUTHENTICATED);

	sprintf(request->start,
          "VERSION %d\nAUTHENTICATOR %s %s\nDIRECTORY ASCII %s\nCREATE-LINK %c %s %s %s %s %s %s %d %d\n",
		VFPROT_VNO, authinfo->auth_type, authinfo->authenticator,
		remdir, ((flags & AVL_UNION) ? 'U' : 'L'),
	   quote(lname), l->type, l->hosttype,l->host,
	   l->nametype, l->filename,l->version,l->f_magic_no);
	
	request->length = strlen(request->start);

	if(pfs_debug > 2)
	    fprintf(stderr,"Sending message to dirsrv:\n%s",request->start);

	resp = dirsend(request,dirhst,0);

	ptlfree(request);

	if(pfs_debug && (resp == NULL)) {
	    fprintf(stderr,"Dirsend failed: %d\n",perrno);
	}

	if(resp == NULL) return(perrno);

	/* Here we parse the response.  Right now we just check the */
	/* first packet.  For this request, it should not take      */
	/* any more than one. If SUCCESS, then we were successful   */
	/* if FAILURE, or anything else, we failed, and should      */
        /* return an appropriate error                              */

	if(pfs_debug > 3) fprintf(stderr,"%s\n",resp->start);

	if(*(resp->start) != 'S') {
	    /* FORWARDED */
	    if(strncmp(resp->start,"FORWARDED",9) == 0) {
		/* parse and start over */

		tmp = sscanf(resp->start,"FORWARDED %*s %s %*s %s %*d %*d", 
			     fwdhst,fwdfnm);

		dirhst = stcopy(fwdhst);
		remdir = stcopy(fwdfnm);

		ptlfree(resp);

		if(tmp < 2) return(DIRSRV_BAD_FORMAT);
		else goto startover;
	    }

	    tmp = scan_error(resp->start);

	    if(pfs_debug)
		fprintf(stderr,"CREATE-LINK: %s\n",resp->start);
	    
	    ptlfree(resp);
	    return(tmp);
	}
	    
	ptlfree(resp);
	return(PSUCCESS);
    }
