/*
 * Copyright (c) 1989, 1990, 1991 by the University of Washington
 *
 * For copying and distribution information, please see the file
 * <uw-copyright.h>.
 */

#include <uw-copyright.h>
#include <stdio.h>
#include <strings.h>

#include <pfs.h>
#include <pprot.h>
#include <perrno.h>
#include <pauthent.h>
#include <pmachine.h>

extern int	pfs_debug;

/*
 */
add_filter(ln,fn,fargs)
    char	*ln;		/* Name of link to receive filter */
    char	*fn;            /* Name (virtual path) of the filter */
    char	*fargs;		/* Argument string for filter */

    {

	char		*dirhst;	   /* Host of current directory    */
	char		*remdir;	   /* Dir on remote host	   */
	
	char		*cname = "";	   /* Component name               */
        char	        *pname = "";	   /* Parent name		   */

	char		pathcpy[MAX_VPATH];

	VLINK		fl;		   /* This is the filter */

        PTEXT		request;	/* Text of request to dir server    */
	PTEXT		resp;	    	/* Response from dir server	    */
	char		fwdhst[MAX_DIR_LINESIZE];
	char		fwdfnm[MAX_DIR_LINESIZE];


	VDIR_ST		dir_st;
	VDIR		dir = &dir_st;

	PAUTH		authinfo;

	int		tmp;

	vdir_init(dir);

	strcpy(pathcpy,ln);
	cname = rindex(pathcpy,'/');
	if(!cname)  cname = pathcpy;
	else {
	    *cname++ = '\0';
	    pname = pathcpy;
	    if(cname == (pname + 1)) pname = "/";
	}

        /* We must first find the directory containing the link  */
        /* to receive the filter                                 */

	tmp = rd_vdir(pname,0,dir,RVD_DFILE_ONLY);
	if (tmp || (dir->links == NULL)) return(DIRSRV_NOT_DIRECTORY);
	dirhst = dir->links->host;
	remdir = dir->links->filename;

	/* Now we must find the filter */
        fl = rd_vlink(fn);
	if(!fl) {
		sprintf(p_err_text," %s not found\n",fn);
		return(PFAILURE);
	    }

	/* If magic number has been modified, set it back to 0 */
	if(fl->f_magic_no < 0) fl->f_magic_no = 0;

    startover:

	request = ptalloc();
	
	authinfo = get_pauth(PFSA_UNAUTHENTICATED);

	sprintf(request->start,
          "VERSION %d\nAUTHENTICATOR %s %s\nDIRECTORY ASCII %s\nMODIFY-LINK %s FILTER ADD D %s %s %s %s %d %d\n",
		VFPROT_VNO, authinfo->auth_type, authinfo->authenticator,
		remdir, cname, fl->hosttype, fl->host,
		fl->nametype,fl->filename,fl->version,fl->f_magic_no);
	
	request->length = strlen(request->start);

	if(fargs) {
	    sprintf(request->start + request->length, " ARGS '%s'", fargs);
	    request->length = strlen(request->start);
	}

	if(pfs_debug > 2)
	    fprintf(stderr,"Sending message to dirsrv:\n%s",request->start);

	resp = dirsend(request,dirhst,0);

	ptlfree(request);

	if(pfs_debug && (resp == NULL)) {
	    fprintf(stderr,"Dirsend failed: %d\n",perrno);
	}

	if(resp == NULL) return(perrno);

	/* Here we parse the response.  Right now we just check the */
	/* first packet.  For this request, it should not take      */
	/* any more than one. If SUCCESS, then we were successful   */
	/* if FAILURE, or anything else, we failed, and should      */
        /* return an appropriate error                              */

	if(pfs_debug > 3) fprintf(stderr,"%s\n",resp->start);

	if(*(resp->start) != 'S') {
	    /* FORWARDED */
	    if(strncmp(resp->start,"FORWARDED",9) == 0) {
		/* parse and start over */

		tmp = sscanf(resp->start,"FORWARDED %*s %s %*s %s %*d %*d", 
			     fwdhst,fwdfnm);

		dirhst = stcopy(fwdhst);
		remdir = stcopy(fwdfnm);

		ptlfree(resp);

		if(tmp < 2) return(DIRSRV_BAD_FORMAT);
		else goto startover;
	    }

	    tmp = scan_error(resp->start);

	    if(pfs_debug)
		fprintf(stderr,"MODIFY-LINK: %s\n",resp->start);
	    
	    ptlfree(resp);
	    return(tmp);
	}
	    
	ptlfree(resp);
	return(PSUCCESS);
    }

