/*
 * Copyright (c) 1989, 1990, 1991 by the University of Washington
 *
 * For copying and distribution information, please see the file
 * <uw-copyright.h>.
 */

#include <uw-copyright.h>
#include <sys/param.h>
#include <stdio.h>
#include <sys/types.h>
#include <sys/param.h>
#include <sys/wait.h>

#include <pfs.h>
#include <pcompat.h>
#include <psite.h>
#include <perrno.h>

/* Retrieve file caching it in /tmp/pfs_cache */
pmap_cache(method,link,npath,am_args)
    char	*method;
    VLINK	link;
    char	*npath;
    char	*am_args;
    {
	char		vcachebin[MAXPATHLEN];
	int 		pid;
	union wait 	status;
	int		tmp;

	sprintf(npath,"/tmp/pfs_cache/%s%s%s",link->host,
		((*(link->filename) == '/') ? "" : "/"),
		link->filename);

	/* Determine whether a cached copy already exists */
	/* If so, check to make sure we still have the    */
	/* current version, and if so use it              */
	/*  **** TO be IMPLEMENTED ***                    */

	/* Otherwise fetch a new copy */

	/* should really do this on our own without */
	/* calling system, but...                   */
	pid = fork();
	if (pid == 0) {
	    sprintf(vcachebin,"%s/vcache",P_BINARIES);
	    /* In execl, add the "-m" option if cache to be managed */
	    /* Add the "-r" option if existing item is out of date  */
	    DISABLE_PFS(execl(vcachebin,"vcache",link->host,link->filename,
		  npath,method,am_args,0));
	    exit(1);
	}
	else {
	    wait(&status); 
	}
	tmp = status.w_T.w_Retcode;

	if(tmp) return(PMC_RETRIEVE_FAILED);

	/* Return PMC_DELETE_ON_CLOSE if cache is not being managed */
	return(PMC_DELETE_ON_CLOSE);

	/* return(PSUCCESS);*/
	    
    }
