/*
 * Copyright (c) 1989, 1990 by the University of Washington
 *
 * For copying and distribution information, please see the file
 * <uw-copyright.h>.
 */

#include <uw-copyright.h>
#include <pcompat.h>

extern int	pfs_enable;

int		pfs_default = -1;

char		*getenv();

get_pfs_default()
    {
	char	*vfs_default_string;

	/* if vfs_disable_flag is set to disable, skip as there  */
	/* is probably a reason for it                           */
	if(pfs_enable == PMAP_DISABLE) return;

	/* Check VFS_DEFAULT and if set, set vfs_disable_flag */
	if(pfs_default == -1) {
	    vfs_default_string = getenv("PFS_DEFAULT");
	    if(vfs_default_string == 0) pfs_default = -2;
	    else if(sscanf(vfs_default_string,"%d",&pfs_default) != 1)
		pfs_default = -2;
	    else pfs_enable = pfs_default;
	}
    }


    
