/*
 * Copyright (c) 1989, 1990, 1991 by the University of Washington
 *
 * For copying and distribution information, please see the file
 * <uw-copyright.h>.
 */

#include <uw-copyright.h>
#include <stdio.h>
#include <strings.h>
#include <sys/file.h>
#include <sys/param.h>
#include <errno.h>

#include <pfs.h>
#include <psite.h>
#include <pcompat.h>
#include <perrno.h>
#include <pmachine.h>

extern int	errno;

/*
 * see pcompat.h for the meanings of the flage
 */
pfs_access(path,npath,flags)
    char	*path;
    char	*npath;
    int		flags;
    {

	char		cpath[MAXPATHLEN];
	char		*prefix;
	char		*suffix;
	VLINK		vl;
	int		tmp;

	suffix = "";

	check_pfs_default();
	    
	/* If disabled, do no mapping */
	if(pfs_enable == PMAP_DISABLE) {
	    strcpy(npath,path);
	    return(PSUCCESS);
	}

	if(pfs_enable == PMAP_COLON) {
	    if(*path == ':') path++;
	    else if(index(path,':'));
	    else {strcpy(npath,path); return(PSUCCESS);}
	}

	if(pfs_enable == PMAP_ATSIGN) {
	    if(*path == '@') {
		path++;
		strcpy(npath,path); 
		return(PSUCCESS);
	    }
	}

	/* I should probably choose better values for errno */
	vl = rd_vlink(path);
	if((perrno || !vl) && ((flags == PFA_CRMAP)||(flags == PFA_CREATE))) {
	    strcpy(cpath,path);
	    prefix = cpath;
	    suffix = rindex(cpath,'/');
	    if(suffix) {
		if(suffix == prefix) prefix = "/";
		*(suffix++) = '\0';
		vl = rd_vlink(prefix);
		if(vl) {
		    sprintf(cpath,"%s/%s",vl->filename,suffix);
		    vl->filename = stcopyr(cpath,vl->filename);
		}
	    }
	}

	if(perrno) {errno = ENOENT;return(perrno);}
	if(!vl) {errno = ENOENT;return(PFS_FILE_NOT_FOUND);}

	tmp = mapname(vl,npath,((flags & PFA_RO) ? 
				MAP_READONLY : MAP_READWRITE));
	vllfree(vl);
	if(tmp && (tmp != PMC_DELETE_ON_CLOSE)) errno = ENOENT;
	return(tmp);
    }

