/*
 * Copyright (c) 1989, 1990, 1991 by the University of Washington
 *
 * For copying and distribution information, please see the file
 * <uw-copyright.h>.
 */

#include <uw-copyright.h>
#include <stdio.h>
#include <strings.h>
#include <netdb.h>
#include <sys/file.h>
#include <sys/param.h>
#include <errno.h>

#include <pfs.h>
#include <pcompat.h>
#include <perrno.h>
#include <pmachine.h>

extern int	pfs_enable;
extern int	perrno;
extern int	pfs_quiet;
extern int	errno;

open(path,flags,mode)
    char	*path;
    int		flags;
    int		mode;
    {
	char		npath[MAXPATHLEN];

	int		pfaflags;
	int		tmp;
	int		open_return;

	if(flags & O_CREAT) pfaflags = PFA_CRMAP;
	else pfaflags = PFA_MAP;
	if((flags & (O_ACCMODE)) == O_RDONLY) pfaflags |= PFA_RO;

	tmp = pfs_access(path,npath,pfaflags);

	if(tmp && (tmp != PMC_DELETE_ON_CLOSE)) {
	    if(!pfs_quiet) printf("open failed: %s\n",p_err_text[tmp]);
	    errno = ENOENT;
	    return(-1);
	}

	open_return = _n_open(npath,flags,mode);
	if(tmp == PMC_DELETE_ON_CLOSE) unlink(npath);
	
	return(open_return);
    }
