/*
 * Copyright (c) 1989, 1990, 1991 by the University of Washington
 *
 * For copying and distribution information, please see the file
 * <uw-copyright.h>.
 */

#include <uw-copyright.h>
#include <strings.h>
#include <netdb.h>

#include <pfs.h>
#include <psite.h>
#include <pcompat.h>
#include <perrno.h>
#include <pmachine.h>

static char	myvhostname[40] = {0};

/*
 * see pcompat.h for the meanings of the flags
 */
mapname(link,npath,readonly)
    VLINK	link;
    char	*npath;
    int		readonly;
    {

	char		am_args[MAX_PTXT_LEN];
	int		am;
	int		tmp;
	int		methods = 0;

	struct hostent	*current_host;

	/* First time called, find out hostname and remember it */
	if(!(*myvhostname)) {
	    /* Here we should really get the host name in cannonical form */
	    gethostname(myvhostname,sizeof(myvhostname));

	    /* gethostbyname reads files, so we must disable pfs */
	    DISABLE_PFS(current_host = gethostbyname(myvhostname));

	    strcpy(myvhostname,current_host->h_name);
	    ucase(myvhostname);
	}

	/* If local, map the pathname and return immediately */
	if((!strcmp(myvhostname,link->host))||(!strcmp("LOCALHOST",link->host))) {
	    strcpy(npath,link->filename);
	    return(PSUCCESS);
	}

#ifdef P_NFS
	methods |= P_AM_NFS;
#endif P_NFS

#ifdef P_AFS
	methods |= P_AM_AFS;
#endif P_AFS

	if(readonly) methods |= P_AM_AFTP;

	am = pget_am(link,am_args,methods);

	if(!am && perrno) {
	    return(perrno);
	}

	switch(am) {

#ifdef P_NFS
	case P_AM_NFS: 
	    tmp = pmap_nfs(link->host,link->filename,npath,am_args);
	    return(tmp);
#endif P_NFS

#ifdef P_AFS
	case P_AM_AFS: 
	    strcpy(npath,P_AFS);
	    strcat(npath,am_args);
	    return(PSUCCESS);
#endif P_AFS

	case P_AM_AFTP: 
	    tmp = pmap_cache("AFTP",link,npath,am_args);
	    return(tmp);

	default:
	    return(PFSA_AM_NOT_SUPPORTED);
	}
    }


