/*
 * Copyright (c) 1989, 1990, 1991 by the University of Washington
 *
 * For copying and distribution information, please see the file
 * <uw-copyright.h>.
 */

#include <uw-copyright.h>
#include <sys/param.h>
#include <sys/dir.h>
#include <stdio.h>

#include <pfs.h>
#include <pcompat.h>
#include <perrno.h>
#include <pmachine.h>

/* Maximum open virtual directories */
#define MAX_VDDESC 16

extern int	pfs_enable;
extern int	pfs_default;

static struct direct	*dirbuf[MAX_VDDESC + 1] = {NULL};
static int		dirpos[MAX_VDDESC + 1]  = {0};
static int		dirbsz[MAX_VDDESC + 1]  = {0};

getvdirentries(fd, buf, nbytes, basep)
    int		fd;
    char	*buf;
    int		nbytes;
    int		*basep;
    {
	int		bytes = 0;
	struct direct	*dp;
	char		*bp;

	if(fd > -1) return(0);
	if(fd < - MAX_VDDESC) return(0);
	
	dp = (struct direct *) ((char *)dirbuf[-fd] + dirpos[-fd]);

	while(dp->d_reclen && (dp->d_reclen <= nbytes)) {
	    bcopy(dp,buf,dp->d_reclen);
	    nbytes = nbytes - (unsigned short) dp->d_reclen;
	    buf = buf + (unsigned short) dp->d_reclen;
	    bytes = bytes + (unsigned short) dp->d_reclen;
	    bp = (char *) dp;bp += dp->d_reclen;dp = (struct direct *) bp;
	}

	*basep = dirpos[-fd];
	dirpos[-fd] = dirpos[-fd] + bytes;
	return(bytes);
    }
    

readvdirentries(dirname)
    char	*dirname;
    {
	VDIR_ST		dir_st;
	VDIR		dir= &dir_st;
	VLINK		l;

	long		dsize = 0;
	int		dirnum = 0;
	struct direct	*dp;
	int		tmp;

	vdir_init(dir);

	check_pfs_default();
	    
	/* If disabled, do no mapping */
	if(pfs_enable == PMAP_DISABLE) return(PSUCCESS);

	/* This is a kludge.  We should not be modifying the */
	/* path arg, but...                                  */
	if(pfs_enable == PMAP_ATSIGN) {
	    if(*dirname == '@') {
		strcpy(dirname,dirname+1);
		return(PSUCCESS);
	    }
	}

	if(pfs_enable == PMAP_COLON) {
	    if(*dirname == ':') dirname++;
	    else  return(PSUCCESS);
	}

	tmp = rd_vdir(dirname,0,dir,RVD_LREMEXP);

	if(tmp) return(tmp);

	l = dir->links;

	while(l) {
	    /* The next statement should track the DIRSIZ macro */
	    dsize = dsize + (sizeof(struct direct) - (MAXNAMLEN+1)) +
		((strlen(l->name)+1 +3) & ~3);

	    l = l->next;
	}

	/* This is just in case */
	dsize = dsize + 256;

	dirnum = 0;
	while(dirnum++ <= MAX_VDDESC) {
	    if(!dirbuf[dirnum]) break;
	    }
	if(dirnum > MAX_VDDESC) return(PFAILURE);
	
	dp = (struct direct *) malloc(dsize);
	dirbuf[dirnum] = dp;
	dirpos[dirnum] = 0;
	dirbsz[dirnum] = dsize;

	l = dir->links;

	while(l) {
	    dp->d_ino = (unsigned long) 999;
	    dp->d_namlen = (unsigned short) strlen(l->name);
	    dp->d_reclen = (unsigned short) DIRSIZ(dp);
	    strcpy(dp->d_name,l->name);
	    dp = (struct direct *) ((char *) dp + dp->d_reclen);
	    l = l->next;
	}	
	
	dp->d_ino = (unsigned long) 0;
	dp->d_reclen = (unsigned short) 0;
	dp->d_namlen = (unsigned short) 0;
	*(dp->d_name) = '\0';

	vllfree(dir->links);
	vllfree(dir->ulinks);

	return(-dirnum);

    }


delvdirentries(desc)
    int desc;
    {
	if(desc > -1) return(PFAILURE);
	if(desc < - MAX_VDDESC) return(PFAILURE);

	if(dirbuf[- desc]) {
	    free(dirbuf[- desc]);
	    dirbuf[- desc] = NULL;
	    return(PSUCCESS);
	}
	return(PFAILURE);
    }

seekvdir(desc,pos)
    int desc;
    int pos;
    {
	if(desc > -1) return(PFAILURE);
	if(desc < - MAX_VDDESC) return(PFAILURE);
	if(!dirbuf[- desc]) return(PFAILURE);
	dirpos[-desc] = pos;
	return(PSUCCESS);
    }

getvdbsize(desc,pos)
    int desc;
    int pos;
    {
	if(desc > -1) return(PFAILURE);
	if(desc < - MAX_VDDESC) return(PFAILURE);
	if(!dirbuf[- desc]) return(PFAILURE);
	return(dirbsz[-desc]);
    }

