/*
 * Copyright (c) 1989, 1990 by the University of Washington
 *
 * For copying and distribution information, please see the file
 * <uw-copyright.h>.
 */

#include <uw-copyright.h>

/*
 * This file defines the types of log messages logged by vlog.  Each
 * type of message may be selectively turned on or off. 
 */

#ifndef PFS_LOGFILE
#define PFS_LOGFILE  "pfs.log"  /* master server                    */
#endif  PFS_LOGFILE

#define MXVLOGENTRY	1000	/* Maximum length of single entry   */

#define	NLOGTYPE	100	/* Maximum number of log msg types  */

#define L_USER_IDS	  0	/* Include user IDs when available  */
#define L_STATUS	  1	/* General status message	    */
#define L_DEATH_REQ       2	/* Request for server death	    */
#define L_NET_ERR	  3	/* Error in network code	    */
#define L_NET_INFO	  4	/* Info on network activity	    */
#define L_DIR_PERR	  5	/* VFS Directory protocol errors    */
#define L_DIR_PINFO	  6	/* VFS Directory protocol info	    */
#define L_DIR_PWARN       7	/* VFS Direcoty protocol warning    */
#define L_DIR_ERR	  8	/* VFS Request error		    */
#define L_DIR_INFO	  9	/* VFS Request information	    */
#define L_DIR_UINFO      10     /* VFS Update information           */
#define L_DIR_WARN	 11	/* VFS Request warning		    */
#define L_DATA_FRM_ERR   12     /* Virtual Directory Format Error   */
#define L_AUTH_ERR       13     /* Attempted Unauthorized Operation */
#define L_QUEUE_INFO     14     /* Info on queue managment          */
#define L_ERR_UNK  NLOGTYPE	/* Unknown error type		    */

#ifndef INITIAL_LOG_VECTOR
#define INITIAL_LOG_VECTOR	{1,1,1,1,0,1,1,1,1,1,1,1,1,1,1,1,1,1}
#endif  INITIAL_LOG_VECTOR

char	*plog();
